/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeColumn;
import org.osgi.service.prefs.BackingStoreException;

public class APart {
    private Cursor busy;
    private Cursor idle;
    private Shell busyShell;

    protected <T> T[] adaptArraySelection(Class<T> clazz, Object[] arraySel) {
        if (arraySel == null || arraySel.length == 0 || arraySel[0] == null || !arraySel[0].getClass().isAssignableFrom(clazz)) {
            return null;
        }
        Object o = Array.newInstance(clazz, arraySel.length);
        Object[] values = (Object[])o;
        int i = 0;
        while (i < values.length) {
            values[i] = clazz.cast(arraySel[i]);
            ++i;
        }
        return values;
    }

    protected void registerSelectionService(Viewer viewer, final ESelectionService selectionService) {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                    selectionService.setSelection(null);
                    return;
                }
                IStructuredSelection ssel = (IStructuredSelection)selection;
                if (ssel.size() == 1) {
                    selectionService.setSelection(ssel.getFirstElement());
                } else {
                    selectionService.setSelection((Object)ssel.toArray());
                }
            }
        });
    }

    protected void showErrMsg(Exception e, Shell shell) {
        ErrorDialog.openError((Shell)shell, (String)"Errore", (String)"Errore", (IStatus)this.createMultiStatus(e.getLocalizedMessage(), e));
        e.printStackTrace();
    }

    protected void showWarnMsg(Exception e, Shell shell) {
        ErrorDialog.openError((Shell)shell, (String)"Attenzione", (String)"Warning", (IStatus)this.createMultiStatus(e.getLocalizedMessage(), e));
        e.printStackTrace();
    }

    protected MultiStatus createMultiStatus(String msg, Throwable t) {
        StackTraceElement[] stackTraces;
        ArrayList<Status> childStatuses = new ArrayList<Status>();
        StackTraceElement[] stackTraceElementArray = stackTraces = Thread.currentThread().getStackTrace();
        int n = stackTraces.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTrace = stackTraceElementArray[n2];
            Status status = new Status(4, "com.vela.common.videosupport", stackTrace.toString());
            childStatuses.add(status);
            ++n2;
        }
        MultiStatus ms = new MultiStatus("com.vela.common.videosupport", 4, (IStatus[])childStatuses.toArray(new Status[0]), msg, t);
        return ms;
    }

    protected void showErrMsg(List<String> msgs, Shell shell) {
        ErrorDialog.openError((Shell)shell, (String)"Errore", (String)"Errore elaborazione", (IStatus)this.createMultiStatus(msgs));
    }

    protected void showWarnMsg(List<String> msgs, Shell shell) {
        ErrorDialog.openError((Shell)shell, (String)"Attenzione", (String)"Warning elaborazione", (IStatus)this.createMultiStatus(msgs));
    }

    private MultiStatus createMultiStatus(List<String> msgs) {
        ArrayList<Status> childStatuses = new ArrayList<Status>();
        boolean first = true;
        String firstMsg = null;
        for (String msg : msgs) {
            if (first) {
                firstMsg = msg;
                first = false;
            }
            Status status = new Status(4, "com.vela.common.videosupport", msg);
            childStatuses.add(status);
        }
        MultiStatus ms = new MultiStatus("com.vela.common.videosupport", 4, (IStatus[])childStatuses.toArray(new Status[0]), firstMsg != null ? firstMsg : "Problemi rilevati durante il processo", null);
        return ms;
    }

    protected void setBusy() {
        Shell shell = this.getActiveShell();
        if (shell == null) {
            return;
        }
        this.initCursors();
        this.busyShell = shell;
        shell.setCursor(this.busy);
    }

    private Shell getActiveShell() {
        Display d = Display.getCurrent();
        if (d == null) {
            return null;
        }
        Shell s = d.getActiveShell();
        if (s == null && d.getShells().length > 0) {
            s = d.getShells()[0];
        }
        return s;
    }

    private void initCursors() {
        this.busy = this.busy != null ? this.busy : Display.getCurrent().getSystemCursor(1);
        this.idle = this.idle != null ? this.idle : Display.getCurrent().getSystemCursor(0);
    }

    protected void setIdle() {
        Shell shell;
        Shell shell2 = shell = this.busyShell != null ? this.busyShell : this.getActiveShell();
        if (shell == null) {
            return;
        }
        this.busyShell = null;
        this.initCursors();
        shell.setCursor(this.idle);
    }

    protected void restoreLayout(TableViewer tableViewer, IEclipsePreferences prefs) {
        String colOrder = prefs.get("colOrder", null);
        String colWidth = prefs.get("colWidth", null);
        try {
            if (colOrder != null) {
                tableViewer.getTable().setColumnOrder(this.fromStringArray(colOrder));
            }
            if (colWidth != null) {
                int[] widths = this.fromStringArray(colWidth);
                TableColumn[] cols = tableViewer.getTable().getColumns();
                int i = 0;
                while (i < widths.length && i < cols.length) {
                    cols[i].setWidth(widths[i]);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void restoreLayout(TreeViewer treeViewer, IEclipsePreferences prefs) {
        String colOrder = prefs.get("colOrder", null);
        String colWidth = prefs.get("colWidth", null);
        try {
            if (colOrder != null) {
                treeViewer.getTree().setColumnOrder(this.fromStringArray(colOrder));
            }
            if (colWidth != null) {
                int[] widths = this.fromStringArray(colWidth);
                TreeColumn[] cols = treeViewer.getTree().getColumns();
                int i = 0;
                while (i < widths.length && i < cols.length) {
                    cols[i].setWidth(widths[i]);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int[] fromStringArray(String colOrder) {
        String[] data = colOrder.replace("[", "").replace("]", "").split(",");
        int[] result = new int[data.length];
        int i = 0;
        while (i < data.length) {
            result[i] = Integer.parseInt(data[i].trim());
            ++i;
        }
        return result;
    }

    protected void storeLayout(TableViewer tableViewer, IEclipsePreferences prefs) {
        if (tableViewer != null) {
            int[] colOrder = tableViewer.getTable().getColumnOrder();
            prefs.put("colOrder", Arrays.toString(colOrder));
            prefs.put("colWidth", Arrays.toString((Object[])Arrays.asList(tableViewer.getTable().getColumns()).stream().map(c -> c.getWidth()).collect(Collectors.toList()).toArray(new Integer[0])));
        } else {
            prefs.remove("colOrder");
            prefs.remove("colWidth");
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    protected void storeLayout(TreeViewer treeViewer, IEclipsePreferences prefs) {
        if (treeViewer != null) {
            int[] colOrder = treeViewer.getTree().getColumnOrder();
            prefs.put("colOrder", Arrays.toString(colOrder));
            prefs.put("colWidth", Arrays.toString((Object[])Arrays.asList(treeViewer.getTree().getColumns()).stream().map(c -> c.getWidth()).collect(Collectors.toList()).toArray(new Integer[0])));
        } else {
            prefs.remove("colOrder");
            prefs.remove("colWidth");
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

