/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport;

import com.vela.videosupport.ColorProvider;
import com.vela.videosupport.EditorValuesProvider;
import com.vela.videosupport.UITableColumn;
import com.vela.videosupport.UITableInnerColumn;
import com.vela.videosupport.ValueFormatter;
import com.vela.videosupport.editingsupport.IDescriptor;
import com.vela.videosupport.formatters.Formatters;
import com.vela.videosupport.jfacesupport.IFilterTextProvider;
import com.vela.videosupport.jfacesupport.IModelModifyListener;
import com.vela.videosupport.jfacetable.JFaceTableBuilder;
import com.vela.videosupport.jfacetree.JFaceTreeBuilder;
import com.vela.videosupport.nattable.NatTableBuilder;
import com.vela.videosupport.support.DftEnumComparator;
import com.vela.videosupport.support.DftPrimitiveComparator;
import com.vela.videosupport.support.TableColumnModel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;

public abstract class ATableBuilder<T> {
    protected TableColumnModel[] modelColumns;
    protected boolean autoSize = false;
    protected boolean sorted = false;
    protected boolean disableFilter;
    protected boolean disableSort;
    protected TableColumnModel[] filterColumns;

    public abstract void init();

    protected void initModel(Class<T> model) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArrayList<TableColumnModel> columns = new ArrayList<TableColumnModel>();
        this.parseModel(model, columns, null);
        if (columns.isEmpty()) {
            throw new RuntimeException(MessageFormat.format("Per la classe {0} non vi sono colonne attive", model));
        }
        this.filterColumns = columns.stream().filter(p -> p.isFilterable()).collect(Collectors.toList()).toArray(new TableColumnModel[0]);
        this.modelColumns = columns.toArray(new TableColumnModel[0]);
    }

    protected void parseModel(Class<?> model, List<TableColumnModel> columns, List<Method> methodQueue) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        List validMethods = Arrays.asList(model.getMethods()).stream().filter(m -> m.getAnnotation(UITableColumn.class) != null || m.getAnnotation(UITableInnerColumn.class) != null).collect(Collectors.toCollection(ArrayList::new));
        Collections.sort(validMethods, (a, b) -> {
            int x = 0;
            int y = 0;
            UITableColumn col1 = a.getAnnotation(UITableColumn.class);
            x = col1 == null ? a.getAnnotation(UITableInnerColumn.class).columnOrder() : col1.columnOrder();
            UITableColumn col2 = b.getAnnotation(UITableColumn.class);
            y = col2 == null ? b.getAnnotation(UITableInnerColumn.class).columnOrder() : col2.columnOrder();
            return x - y;
        });
        for (Method method : validMethods) {
            UITableColumn columnAnn = method.getAnnotation(UITableColumn.class);
            if (columnAnn != null) {
                if (methodQueue != null && !columnAnn.mainColumn() && !columnAnn.keyColumn()) continue;
                columns.add(this.buildColumnModel(method, methodQueue, columnAnn));
            }
            if (method.getAnnotation(UITableInnerColumn.class) == null) continue;
            ArrayList<Object> innerQueue = null;
            innerQueue = methodQueue == null ? new ArrayList() : new ArrayList<Method>(methodQueue);
            innerQueue.add(method);
            this.parseModel(method.getReturnType(), columns, innerQueue);
        }
    }

    protected TableColumnModel buildColumnModel(Method method, List<Method> parentMethod, UITableColumn columnAnn) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<? extends EditorValuesProvider> valuesp;
        Class<? extends ColorProvider> colp;
        Class<? extends ValueFormatter> form;
        TableColumnModel column = new TableColumnModel();
        column.setColumnSize(columnAnn.columnSize());
        column.setLabel(columnAnn.label());
        column.setScale(columnAnn.scale());
        column.setMain(columnAnn.mainColumn() || columnAnn.keyColumn());
        column.setSortable(columnAnn.sortable() && !this.disableSort);
        column.setFilterable(columnAnn.filterable() && !this.disableFilter);
        column.setEditable(columnAnn.editable());
        column.setSelectable(columnAnn.selectable());
        column.setRegExValidator(columnAnn.regExValidator());
        column.setMethod(method);
        column.setDescendentMethods(parentMethod);
        if (method.getParameterCount() > 0) {
            throw new RuntimeException(MessageFormat.format("E'' stato indicato il metodo {0} contenente parametri in ingresso, non \u00e8 possibile utilizzarlo come colonna", method));
        }
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            throw new RuntimeException(MessageFormat.format("E'' stato indicato il metodo {0} senza return type in ritorno, non \u00e8 possibile utilizzarlo come colonna", method));
        }
        Class<Comparator> cmp = columnAnn.valueComparator();
        if (cmp.isInterface()) {
            cmp = null;
        }
        if ((form = columnAnn.valueFormatter()).isInterface()) {
            form = null;
        }
        if ((colp = columnAnn.colorProvider()).isInterface()) {
            colp = null;
        }
        if ((valuesp = columnAnn.editorValuesProvider()).isInterface()) {
            valuesp = null;
        }
        if (columnAnn.sortable() && !this.disableSort) {
            this.sorted = true;
            if (cmp == null && returnType.isEnum()) {
                cmp = DftEnumComparator.class;
            }
            if (cmp == null && returnType.isPrimitive()) {
                cmp = DftPrimitiveComparator.class;
            }
            if (cmp == null && !Comparable.class.isAssignableFrom(returnType)) {
                throw new RuntimeException(MessageFormat.format("E'' stato indicato un tipo di ritorno {0} per cui non \u00e8 possibile effettuare il sort, non \u00e8 possibile utilizzarlo come colonna", method));
            }
        }
        if (valuesp != null) {
            column.setEditorValuesProvider(valuesp.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        if (form == null) {
            column.setValueFormatter(Formatters.get(returnType, column.getScale()));
        } else {
            column.setValueFormatter(form.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        if (colp != null) {
            column.setColorProvider(colp.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        if (cmp != null) {
            column.setValueComparator(cmp.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        column.setRightAligned(Number.class.isAssignableFrom(returnType));
        this.autoSize |= column.getColumnSize() > 0;
        return column;
    }

    public static final <T> ATableBuilder<T> get(TableViewer table, IFilterTextProvider filterProvider, IModelModifyListener modifyListener, Class<T> model) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return ATableBuilder.get(table, filterProvider, modifyListener, model, false, false);
    }

    public static final <T> ATableBuilder<T> get(TreeViewer tree, IFilterTextProvider filterProvider, IModelModifyListener modifyListener, Class<T> model) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return ATableBuilder.get(tree, filterProvider, modifyListener, model, false, false);
    }

    public static final <T> ATableBuilder<T> get(TableViewer table, IFilterTextProvider filterProvider, IModelModifyListener modifyListener, Class<T> model, boolean disableFilter, boolean disableSort) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return new JFaceTableBuilder<T>(table, filterProvider, modifyListener, model, disableFilter, disableSort);
    }

    public static final <T> ATableBuilder<T> get(TreeViewer tree, IFilterTextProvider filterProvider, IModelModifyListener modifyListener, Class<T> model, boolean disableFilter, boolean disableSort) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return new JFaceTreeBuilder<T>(tree, filterProvider, modifyListener, model, disableFilter, disableSort);
    }

    public static final <T> ATableBuilder<T> get(Composite parent, IDescriptor<T> provider, ISelectionChangedListener changeListener, Class<T> model) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return new NatTableBuilder<T>(parent, provider, changeListener, model);
    }
}

