/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NumericText {
    private final Text innerText;
    private final DecimalFormat formatter;

    public NumericText(Composite parent, int style, int integer, int fraction) {
        this.innerText = new Text(parent, style | 0x20000);
        this.formatter = new DecimalFormat();
        this.formatter.setMaximumIntegerDigits(integer);
        this.formatter.setMaximumFractionDigits(fraction);
        this.formatter.setMinimumFractionDigits(fraction);
        this.formatter.setGroupingUsed(true);
        this.formatter.setParseBigDecimal(true);
        this.formatter.setRoundingMode(RoundingMode.HALF_UP);
        this.innerText.addTraverseListener(t -> {
            if (!this.innerText.getText().isEmpty() && t.detail == 4 | t.detail == 16 | t.detail == 8) {
                ParsePosition pp = new ParsePosition(0);
                BigDecimal v = (BigDecimal)this.formatter.parse(this.innerText.getText(), pp);
                this.innerText.setText(this.formatter.format(v));
            }
        });
        this.innerText.addVerifyListener(e -> {
            if (e.character != '.' && e.character != ',' && e.character != '+' && e.character != '-' && !Character.isDigit(e.character) && !Character.isISOControl(e.character)) {
                e.doit = false;
                return;
            }
            String t = String.valueOf(this.innerText.getText()) + e.text;
            if (t.isEmpty()) {
                return;
            }
            ParsePosition pp = new ParsePosition(0);
            Number n = this.formatter.parse(t, pp);
            if (pp.getErrorIndex() >= 0) {
                this.innerText.setText(this.formatter.format(n));
            }
        });
    }

    public BigDecimal getValue() {
        if (this.innerText.getText().isEmpty()) {
            return BigDecimal.ZERO;
        }
        ParsePosition pp = new ParsePosition(0);
        return (BigDecimal)this.formatter.parse(this.innerText.getText(), pp);
    }

    public void setLayoutData(GridData gd) {
        this.innerText.setLayoutData((Object)gd);
    }

    public void setValue(BigDecimal value) {
        if (value != null) {
            this.innerText.setText(this.formatter.format(value));
        }
    }

    public void addListener(int eventType, Listener listener) {
        this.innerText.addListener(eventType, listener);
    }

    public Text getInnerText() {
        return this.innerText;
    }

    public boolean setFocus() {
        return this.innerText.setFocus();
    }

    public void setVisible(boolean b) {
        this.innerText.setVisible(b);
    }

    public void setEnabled(boolean b) {
        this.innerText.setEnabled(b);
    }

    public void setToolTipText(String string) {
        this.innerText.setToolTipText(string);
    }
}

