/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.editingsupport;

import com.vela.videosupport.UITableColumn;
import com.vela.videosupport.editingsupport.EditableTextElement;
import com.vela.videosupport.editingsupport.IDescriptor;
import com.vela.videosupport.editingsupport.IEditableValidator;
import jakarta.persistence.Id;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Optional;

public class DBEditableValidator<B>
implements IEditableValidator<String> {
    private final IDescriptor<?> dao;
    private final EditableTextElement<?> editorElement;
    private B valObj;
    private Method keyMethod;
    private Method descrMethod;

    public <A> DBEditableValidator(IDescriptor<?> dao, EditableTextElement<A> editorElement) {
        this.dao = dao;
        this.editorElement = editorElement;
    }

    @Override
    public String validate(String value) {
        this.valObj = null;
        if (value.isEmpty()) {
            return null;
        }
        Object obj = null;
        try {
            obj = this.dao.getModel(this.editorElement.parse(value));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Campo chiave non valido";
        }
        if (obj == null) {
            return MessageFormat.format("La chiave indicata {0} non \u00e8 presente su database", value);
        }
        this.valObj = obj;
        return null;
    }

    public B getValidatedModel() {
        return this.valObj;
    }

    public Object getPrimaryKey(Object obj) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (obj == null) {
            return "";
        }
        if (this.keyMethod == null) {
            Field[] fieldArray = obj.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (Optional.ofNullable(f.getAnnotation(Id.class)).isPresent()) {
                    String name = f.getName();
                    String getter = "get" + name.substring(0, 1).toUpperCase();
                    if (name.length() > 1) {
                        getter = String.valueOf(getter) + name.substring(1);
                    }
                    this.keyMethod = obj.getClass().getMethod(getter, new Class[0]);
                    break;
                }
                ++n2;
            }
        }
        if (this.keyMethod != null) {
            return this.keyMethod.invoke(obj, new Object[0]);
        }
        return "";
    }

    public String getPrimaryDescription(Object obj) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (obj == null) {
            return "";
        }
        if (this.descrMethod == null) {
            Method[] methodArray = obj.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (Optional.ofNullable(m.getAnnotation(UITableColumn.class)).filter(utc -> utc.mainColumn()).isPresent()) {
                    this.descrMethod = m;
                    break;
                }
                ++n2;
            }
        }
        if (this.descrMethod != null) {
            return (String)this.descrMethod.invoke(obj, new Object[0]);
        }
        return "";
    }
}

