/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.editingsupport;

import com.vela.videosupport.PerspectiveHelper;
import com.vela.videosupport.editingsupport.SaveAction;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.internal.workbench.E4XMIResourceFactory;
import org.eclipse.e4.ui.internal.workbench.PartServiceSaveHandler;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.workbench.Selector;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ElementMatcher;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.e4.ui.workbench.modeling.IWindowCloseHandler;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class E4EditorLifeCycle {
    protected abstract String getMainWindowId();

    private MPerspectiveStack findstack(List<MWindowElement> children) {
        if (children == null || children.isEmpty()) {
            return null;
        }
        for (MWindowElement element : children) {
            if (!(element instanceof MPerspectiveStack)) continue;
            return (MPerspectiveStack)element;
        }
        return null;
    }

    protected class CustomEventHandler
    implements EventHandler {
        private final MApplication application;
        private final EModelService modelService;
        private final boolean storePerspectives;
        private PartServiceSaveHandler saveHandler = null;

        public CustomEventHandler(MApplication application, EModelService modelService, boolean storePerspectives) {
            this.application = application;
            this.modelService = modelService;
            this.storePerspectives = storePerspectives;
        }

        public void handleEvent(Event event) {
            MWindow window = (MWindow)this.modelService.find(E4EditorLifeCycle.this.getMainWindowId(), (MUIElement)this.application);
            this.saveHandler = new CustomSaveHandler();
            window.getContext().set(ISaveHandler.class, (Object)this.saveHandler);
            window.getContext().set(IWindowCloseHandler.class, (Object)new CustomCloseHandler());
            if (this.storePerspectives) {
                this.loadStoredPersectives(window);
            }
        }

        private void loadStoredPersectives(MWindow window) {
            MPerspectiveStack stack = E4EditorLifeCycle.this.findstack(window.getChildren());
            if (stack == null) {
                return;
            }
            E4XMIResourceFactory e4xmiResourceFactory = new E4XMIResourceFactory();
            for (MPerspective p : stack.getChildren()) {
                if (!Boolean.valueOf(Optional.ofNullable(p.getProperties()).map(s -> (String)s.get("stored")).orElse(null)).booleanValue()) continue;
                Resource resource = e4xmiResourceFactory.createResource(null);
                try {
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try (FileInputStream inputStream = new FileInputStream(PerspectiveHelper.getFileNameForPersistence(p.getElementId()));){
                        resource.load((InputStream)inputStream, null);
                        if (resource.getContents().isEmpty()) continue;
                        MPerspective loadedPerspective = (MPerspective)resource.getContents().get(0);
                        MElementContainer perspectiveParent = p.getParent();
                        this.modelService.removePerspectiveModel(p, window);
                        perspectiveParent.getChildren().add(loadedPerspective);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    System.err.println("Impossibile ripristinare la prospettiva");
                    e.printStackTrace();
                }
            }
        }

        private class CustomCloseHandler
        implements IWindowCloseHandler {
            private CustomCloseHandler() {
            }

            public boolean close(MWindow window) {
                Shell shell = (Shell)window.getWidget();
                if (MessageDialog.openConfirm((Shell)shell, (String)"Conferma uscita", (String)"Si desidera uscire dall'applicazione?")) {
                    Collection<EPartService> allPartServices;
                    if (CustomEventHandler.this.storePerspectives) {
                        this.storePerspectives(window);
                    }
                    if (this.containsDirtyParts(allPartServices = this.getAllPartServices())) {
                        return this.iterateOverDirtyParts(allPartServices, window);
                    }
                    return true;
                }
                return false;
            }

            private void storePerspectives(MWindow window) {
                MPerspectiveStack stack = E4EditorLifeCycle.this.findstack(window.getChildren());
                if (stack == null) {
                    return;
                }
                E4XMIResourceFactory e4xmiResourceFactory = new E4XMIResourceFactory();
                for (MPerspective p : stack.getChildren()) {
                    if (!Boolean.valueOf(Optional.ofNullable(p.getProperties()).map(s -> (String)s.get("stored")).orElse(null)).booleanValue()) continue;
                    Resource resource = e4xmiResourceFactory.createResource(null);
                    MUIElement clonedPerspective = CustomEventHandler.this.modelService.cloneElement((MUIElement)p, (MSnippetContainer)window);
                    resource.getContents().add((Object)((EObject)clonedPerspective));
                    try {
                        Throwable throwable = null;
                        Object var9_11 = null;
                        try (FileOutputStream outputStream = new FileOutputStream(PerspectiveHelper.getFileNameForPersistence(p.getElementId()));){
                            resource.save((OutputStream)outputStream, null);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException ex) {
                        System.err.println("Impossibile salvare la perspective");
                        ex.printStackTrace();
                    }
                }
            }

            private Collection<EPartService> getAllPartServices() {
                return CustomEventHandler.this.modelService.findElements((MApplicationElement)CustomEventHandler.this.application, MWindow.class, 2, (Selector)new ElementMatcher(null, MWindow.class, null)).stream().filter(w -> w.isVisible() && w.isToBeRendered()).map(w -> (EPartService)w.getContext().get(EPartService.class)).collect(Collectors.toList());
            }

            private boolean containsDirtyParts(Collection<EPartService> partServices) {
                for (EPartService partService : partServices) {
                    if (partService.getDirtyParts().isEmpty()) continue;
                    return true;
                }
                return false;
            }

            private boolean iterateOverDirtyParts(Collection<EPartService> allPartServices, MWindow window) {
                for (EPartService partService : allPartServices) {
                    Collection dirtyParts = partService.getDirtyParts();
                    for (MPart dirtyPart : dirtyParts) {
                        switch (this.promptToSaveDialog(dirtyPart, window)) {
                            case NO: {
                                break;
                            }
                            case YES: {
                                CustomEventHandler.this.saveHandler.save(dirtyPart, false);
                                break;
                            }
                            case CANCEL: {
                                return false;
                            }
                        }
                    }
                }
                return true;
            }

            private ISaveHandler.Save promptToSaveDialog(MPart dirtyPart, MWindow window) {
                MessageDialog dialog = new MessageDialog((Shell)window.getWidget(), "Salvare?", null, "'" + dirtyPart.getLabel() + "' \u00e8 stato modificato. Procedere con il salvataggio?", 3, new String[]{"Si", "No", "Annulla"}, 0);
                switch (dialog.open()) {
                    case 0: {
                        return ISaveHandler.Save.YES;
                    }
                    case 1: {
                        return ISaveHandler.Save.NO;
                    }
                    case 2: {
                        return ISaveHandler.Save.CANCEL;
                    }
                }
                return ISaveHandler.Save.CANCEL;
            }
        }

        private class CustomSaveHandler
        extends PartServiceSaveHandler {
            private CustomSaveHandler() {
            }

            public boolean save(MPart dirtyPart, boolean confirm) {
                if (confirm) {
                    switch (this.promptToSave(dirtyPart)) {
                        case NO: {
                            return true;
                        }
                        case CANCEL: {
                            return false;
                        }
                    }
                }
                Object client = dirtyPart.getObject();
                try {
                    Object result = ContextInjectionFactory.invoke((Object)client, Persist.class, (IEclipseContext)dirtyPart.getContext());
                    if (result != null && result instanceof SaveAction) {
                        switch ((SaveAction)((Object)result)) {
                            case YES: {
                                return true;
                            }
                            case NO: {
                                return true;
                            }
                            case CANCEL: {
                                return false;
                            }
                        }
                    }
                }
                catch (InjectionException e) {
                    this.log("Failed to persist contents of part", "Failed to persist contents of part ({0})", dirtyPart.getElementId(), (Exception)((Object)e));
                    return false;
                }
                catch (RuntimeException e) {
                    this.log("Failed to persist contents of part via DI", "Failed to persist contents of part ({0}) via DI", dirtyPart.getElementId(), e);
                    return false;
                }
                return true;
            }

            private void log(String unidentifiedMessage, String identifiedMessage, String id, Exception e) {
                if (this.logger == null) {
                    return;
                }
                if (id == null || id.length() == 0) {
                    System.err.println(unidentifiedMessage);
                } else {
                    System.err.println(identifiedMessage);
                }
                System.err.println();
            }
        }
    }
}

