/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.editingsupport;

import com.vela.videosupport.editingsupport.EditableElement;
import com.vela.videosupport.editingsupport.IEditableValidator;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Listener;

public class EditableCheckboxElement
extends EditableElement<Boolean> {
    protected final Button value;
    protected final IEditableValidator<Boolean>[] validators;
    private boolean validated = false;

    public EditableCheckboxElement(Button value, IEditableValidator<Boolean>[] validators) {
        this.value = value;
        this.validators = validators;
        this.validated = false;
    }

    @Override
    public Boolean getDBValue() {
        if (!this.validated) {
            throw new RuntimeException("Processo di validazione non completato, impossibile memorizzare");
        }
        return this.value.getSelection();
    }

    @Override
    public String validate() {
        this.validated = false;
        boolean val = this.value.getSelection();
        IEditableValidator<Boolean>[] iEditableValidatorArray = this.validators;
        int n = this.validators.length;
        int n2 = 0;
        while (n2 < n) {
            IEditableValidator<Boolean> validator = iEditableValidatorArray[n2];
            String result = validator.validate(val);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        this.validated = true;
        return null;
    }

    public void loadDBValue(boolean source) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        this.value.setSelection(source);
    }

    public Button getValue() {
        return this.value;
    }

    @Override
    public void hookModifyListener(Listener listener) {
        this.value.addListener(13, listener);
    }

    @Override
    protected void setEnabled(boolean b) {
        this.value.setEnabled(b);
    }
}

