/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.editingsupport;

import com.vela.videosupport.editingsupport.EditableElement;
import com.vela.videosupport.editingsupport.IEditableValidator;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Listener;

public class EditableComboboxElement<A>
extends EditableElement<A> {
    protected final Combo value;
    protected final IEditableValidator[] validators;
    private boolean validated = false;
    private Enum<?>[] enumVals;
    private String[] enumStrings;

    public EditableComboboxElement(Combo value, Class<A> enumeration, IEditableValidator<A>[] validators) {
        this.value = value;
        this.validators = validators;
        this.validated = false;
        this.initEnumValues(enumeration);
    }

    private void initEnumValues(Class<A> enumv) {
        this.enumVals = enumv.asSubclass(Enum.class).getEnumConstants();
        this.enumStrings = new String[this.enumVals.length];
        int i = 0;
        while (i < this.enumVals.length) {
            this.enumStrings[i] = this.enumVals[i].toString();
            ++i;
        }
        this.value.setItems(this.enumStrings);
    }

    @Override
    public A getDBValue() {
        if (!this.validated) {
            throw new RuntimeException("Processo di validazione non completato, impossibile memorizzare");
        }
        return (A)this.enumVals[this.value.getSelectionIndex()];
    }

    @Override
    public String validate() {
        this.validated = false;
        Enum<?> val = this.enumVals[this.value.getSelectionIndex()];
        IEditableValidator[] iEditableValidatorArray = this.validators;
        int n = this.validators.length;
        int n2 = 0;
        while (n2 < n) {
            IEditableValidator validator = iEditableValidatorArray[n2];
            String result = validator.validate(val);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        this.validated = true;
        return null;
    }

    public void loadDBValue(Enum<?> source) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        this.value.select(0);
        int i = 0;
        while (i < this.enumVals.length) {
            if (this.enumVals[i] == source) {
                this.value.select(i);
                return;
            }
            ++i;
        }
    }

    public Combo getValue() {
        return this.value;
    }

    @Override
    public void hookModifyListener(Listener listener) {
        this.value.addListener(13, listener);
    }

    @Override
    protected void setEnabled(boolean b) {
        this.value.setEnabled(b);
    }
}

