/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.editingsupport;

import com.vela.videosupport.editingsupport.EditableElement;
import com.vela.videosupport.editingsupport.IEditableValidator;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Listener;

public class EditableDateElement<A>
extends EditableElement<A> {
    protected final DateTime date;
    protected final DateTime time;
    protected final Class<A> resultType;
    protected final IEditableValidator<A>[] validators;
    private boolean validated = false;

    public EditableDateElement(DateTime value, DateTime description, Class<A> resultType, IEditableValidator<A>[] validators) {
        this.date = value;
        this.time = description;
        this.resultType = resultType;
        this.validators = validators;
        this.validated = false;
    }

    @Override
    public A getDBValue() {
        if (!this.validated) {
            throw new RuntimeException("Processo di validazione non completato, impossibile memorizzare");
        }
        return this.parse();
    }

    private A parse() {
        int year = 0;
        int month = 0;
        int day = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        Calendar c = Calendar.getInstance();
        c.clear();
        if (this.date != null) {
            year = this.date.getYear();
            month = this.date.getMonth();
            day = this.date.getDay();
            c.set(year, month, day);
        }
        if (this.time != null) {
            hours = this.time.getHours();
            minutes = this.time.getMinutes();
            seconds = this.time.getSeconds();
            c.set(11, hours);
            c.set(12, minutes);
            c.set(13, seconds);
        }
        if (this.resultType.isAssignableFrom(Calendar.class)) {
            return this.resultType.cast(c);
        }
        if (this.resultType.isAssignableFrom(LocalDateTime.class)) {
            return this.resultType.cast(c.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
        }
        if (this.resultType.isAssignableFrom(LocalDate.class)) {
            return this.resultType.cast(c.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        }
        if (this.resultType.isAssignableFrom(LocalTime.class)) {
            return this.resultType.cast(c.toInstant().atZone(ZoneId.systemDefault()).toLocalTime());
        }
        if (this.resultType.isAssignableFrom(OffsetDateTime.class)) {
            return this.resultType.cast(c.toInstant().atZone(ZoneId.systemDefault()).toOffsetDateTime());
        }
        if (this.resultType.isAssignableFrom(OffsetTime.class)) {
            return this.resultType.cast(OffsetTime.ofInstant(c.toInstant(), ZoneId.systemDefault()));
        }
        throw new RuntimeException("E' stato specificato un tipo di classe non supportato per la gestione della data");
    }

    @Override
    public String validate() {
        this.validated = false;
        A value = this.parse();
        IEditableValidator<A>[] iEditableValidatorArray = this.validators;
        int n = this.validators.length;
        int n2 = 0;
        while (n2 < n) {
            IEditableValidator<A> validator = iEditableValidatorArray[n2];
            String result = validator.validate(value);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        this.validated = true;
        return null;
    }

    public void loadDBValue(A source) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Calendar c = null;
        c = source != null ? this.toCalendar(source) : Calendar.getInstance();
        if (this.date != null) {
            this.date.setDate(c.get(1), c.get(2), c.get(5));
        }
        if (this.time != null) {
            this.time.setHours(c.get(11));
            this.time.setMinutes(c.get(12));
            this.time.setSeconds(c.get(13));
        }
    }

    private Calendar toCalendar(A source) {
        if (Calendar.class.isAssignableFrom(source.getClass())) {
            return (Calendar)source;
        }
        if (LocalDateTime.class.isAssignableFrom(source.getClass())) {
            return GregorianCalendar.from(((LocalDateTime)source).atZone(ZoneId.systemDefault()));
        }
        if (LocalDate.class.isAssignableFrom(source.getClass())) {
            return GregorianCalendar.from(((LocalDate)source).atStartOfDay(ZoneId.systemDefault()));
        }
        if (LocalTime.class.isAssignableFrom(source.getClass())) {
            return GregorianCalendar.from(((LocalTime)source).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()));
        }
        if (OffsetDateTime.class.isAssignableFrom(source.getClass())) {
            return GregorianCalendar.from(((OffsetDateTime)source).toZonedDateTime());
        }
        if (LocalTime.class.isAssignableFrom(source.getClass())) {
            return GregorianCalendar.from(((OffsetTime)source).atDate(LocalDate.now()).toZonedDateTime());
        }
        throw new RuntimeException("E' stato specificato un tipo di classe non supportato per la gestione della data");
    }

    public DateTime getValue() {
        return this.date != null ? this.date : this.time;
    }

    @Override
    public void hookModifyListener(Listener listener) {
        if (this.date != null) {
            this.date.addListener(13, listener);
        }
        if (this.time != null) {
            this.time.addListener(13, listener);
        }
    }

    @Override
    protected void setEnabled(boolean b) {
        if (this.date != null) {
            this.date.setEnabled(b);
        }
        if (this.time != null) {
            this.time.setEnabled(b);
        }
    }
}

