/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.editingsupport;

import com.vela.videosupport.APart;
import com.vela.videosupport.editingsupport.DBEditableValidator;
import com.vela.videosupport.editingsupport.EditableCheckboxElement;
import com.vela.videosupport.editingsupport.EditableComboboxElement;
import com.vela.videosupport.editingsupport.EditableDateElement;
import com.vela.videosupport.editingsupport.EditableElement;
import com.vela.videosupport.editingsupport.EditableTextElement;
import com.vela.videosupport.editingsupport.IDescriptor;
import com.vela.videosupport.editingsupport.IEditableValidator;
import com.vela.videosupport.editingsupport.SearchDialog;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class EditablePart
extends APart {
    private int characterWidth;
    protected List<EditableElement<?>> uiElemets = new ArrayList();

    protected boolean validateUI() {
        for (EditableElement<?> ui : this.uiElemets) {
            String msg = ui.validate();
            if (msg == null) continue;
            ui.getValue().setFocus();
            this.showErrMsg(Arrays.asList(msg), ui.getValue().getShell());
            return false;
        }
        return true;
    }

    protected EditableTextElement<String> buildTextField(Composite parent, String label, int limit, IEditableValidator<String> ... validators) {
        return this.buildDbTextField(parent, label, limit, null, 0, validators);
    }

    protected <A> EditableTextElement<A> buildNumericField(Composite parent, String label, int precision, int scale, Class<A> resultType, IEditableValidator<String> ... validators) {
        return this.buildDbNumericField(parent, label, precision, scale, resultType, null, 0, validators);
    }

    protected <B> EditableTextElement<String> buildDbTextField(Composite parent, String label, int size, IDescriptor<B> dao, int descriptionSize, IEditableValidator<String> ... validators) {
        Label lart = new Label(parent, 0);
        Button search = null;
        if (dao != null && dao.getModelProvider().isListable()) {
            search = this.buildSearch(parent);
        } else {
            new Label(parent, 0);
        }
        lart.setText(label);
        Text text = new Text(parent, 2048);
        int width = this.computeWidth(text, size);
        text.setTextLimit(size);
        GridData gd = null;
        gd = new GridData(1, 0x1000000, false, false);
        text.setLayoutData((Object)gd);
        gd.widthHint = width;
        Label description = null;
        if (descriptionSize > 0) {
            int descriptionWidth = this.computeWidth(text, descriptionSize);
            description = new Label(parent, 0);
            gd = new GridData(1, 0x1000000, false, false);
            description.setLayoutData((Object)gd);
            gd.widthHint = descriptionWidth;
        } else {
            gd.horizontalSpan = 2;
        }
        EditableTextElement<String> element = new EditableTextElement<String>(text, description, String.class, null, validators);
        if (dao != null) {
            DBEditableValidator daoV = new DBEditableValidator(dao, element);
            element.setDaoValidator(daoV);
            if (dao != null && description != null) {
                Label fdescr = description;
                text.addTraverseListener(e -> {
                    if (e.detail != 4 && e.detail != 16 && e.detail != 8) {
                        return;
                    }
                    fdescr.setText("");
                    String val = text.getText();
                    if (val == null || val.trim().isEmpty()) {
                        return;
                    }
                    Object obj = dao.getModel(val);
                    try {
                        fdescr.setText(daoV.getPrimaryDescription(obj));
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
                        e1.printStackTrace();
                        this.showErrMsg(e1, fdescr.getShell());
                    }
                });
            }
            if (search != null) {
                this.hookSearch(dao, element, search);
            }
        }
        this.uiElemets.add(element);
        return element;
    }

    protected EditableCheckboxElement buildCheckboxField(Composite parent, String label, IEditableValidator<Boolean> ... validators) {
        new Label(parent, 0).setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        Button checkbox = new Button(parent, 32);
        checkbox.setText(label);
        checkbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        EditableCheckboxElement element = new EditableCheckboxElement(checkbox, validators);
        this.uiElemets.add(element);
        return element;
    }

    protected <A extends Enum<A>> EditableComboboxElement<A> buildComboboxField(Composite parent, String label, Class<A> enumeration, IEditableValidator<? extends Enum> ... validators) {
        Label lart = new Label(parent, 0);
        lart.setText(label);
        lart.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        Combo combo = new Combo(parent, 12);
        combo.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        EditableComboboxElement<? extends Enum> element = new EditableComboboxElement<Enum>(combo, enumeration, validators);
        this.uiElemets.add(element);
        return element;
    }

    protected <T> EditableDateElement<T> buildTemporalField(Composite parent, String label, Class<T> clazz, IEditableValidator<T> ... validators) {
        Label lab = new Label(parent, 0);
        lab.setText(label);
        lab.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        DateTime date = null;
        DateTime time = null;
        if (LocalTime.class.isAssignableFrom(clazz) || OffsetTime.class.isAssignableFrom(clazz)) {
            time = new DateTime(parent, 32896);
            time.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        } else if (LocalDate.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz)) {
            date = new DateTime(parent, 32800);
            date.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        } else {
            Composite c = new Composite(parent, 0);
            c.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
            c.setLayout((Layout)new GridLayout(2, false));
            date = new DateTime(c, 32800);
            time = new DateTime(c, 32896);
        }
        EditableDateElement<T> element = new EditableDateElement<T>(date, time, clazz, validators);
        this.uiElemets.add(element);
        return element;
    }

    private int computeWidth(Text text, int size) {
        if (this.characterWidth == 0) {
            GC gc = new GC((Drawable)text);
            this.characterWidth = gc.stringExtent((String)"W").x;
            gc.dispose();
        }
        int border = text.getBorderWidth();
        return Math.round((size + 2) * this.characterWidth) + border * 2;
    }

    protected <A, B> EditableTextElement<A> buildDbNumericField(Composite parent, String label, int precision, int scale, Class<A> resultType, IDescriptor<B> dao, int descriptionSize, IEditableValidator ... validators) {
        Label lart = new Label(parent, 0);
        Button search = null;
        if (dao != null && dao.getModelProvider().isListable()) {
            search = this.buildSearch(parent);
        } else {
            new Label(parent, 0);
        }
        lart.setText(label);
        Text number = new Text(parent, 133120);
        int size = precision + (scale > 0 ? 1 : 0) + 1 + (precision - scale - 1) / 3;
        int width = this.computeWidth(number, size);
        GridData gd = null;
        gd = new GridData(1, 0x1000000, false, false);
        number.setLayoutData((Object)gd);
        NumberFormat numFormat = this.buildNumericValidation(number, precision, scale);
        gd.widthHint = width;
        Label description = null;
        if (descriptionSize > 0) {
            int descriptionWidth = this.computeWidth(number, descriptionSize);
            description = new Label(parent, 0);
            gd = new GridData(1, 0x1000000, false, false);
            description.setLayoutData((Object)gd);
            gd.widthHint = descriptionWidth;
        } else {
            gd.horizontalSpan = 2;
        }
        EditableTextElement editorElement = new EditableTextElement(number, description, resultType, numFormat, validators);
        if (dao != null) {
            DBEditableValidator daoV = new DBEditableValidator(dao, editorElement);
            editorElement.setDaoValidator(daoV);
            if (dao != null && description != null) {
                Label fdescr = description;
                number.addTraverseListener(e -> {
                    if (e.detail != 4 && e.detail != 16 && e.detail != 8) {
                        return;
                    }
                    fdescr.setText("");
                    String val = number.getText();
                    if (val == null || val.trim().isEmpty()) {
                        return;
                    }
                    try {
                        Object obj = dao.getModel(editorElement.parse(val));
                        fdescr.setText(daoV.getPrimaryDescription(obj));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        this.showErrMsg(e1, fdescr.getShell());
                    }
                });
            }
            if (search != null) {
                this.hookSearch(dao, editorElement, search);
            }
        }
        this.uiElemets.add(editorElement);
        return editorElement;
    }

    private void hookSearch(IDescriptor<?> dao, EditableTextElement<?> element, Button search) {
        if (dao == null) {
            throw new RuntimeException("Per una propriet\u00e0 per cui + prevista la ricerca non \u00e8 stato fornito l'oggetto DAO relativo");
        }
        search.addListener(13, l -> {
            SearchDialog searchDialog = new SearchDialog(search.getShell(), dao.getDataClass(), dao);
            if (searchDialog.open() == 0 && searchDialog.getSelection() != null) {
                try {
                    element.loadDBValue(searchDialog.getSelection());
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    this.showErrMsg(e, search.getShell());
                    e.printStackTrace();
                }
            }
        });
    }

    private Button buildSearch(Composite parent) {
        Button search = new Button(parent, 8);
        search.setText("\ud83d\udd0d");
        search.setToolTipText("Ricerca");
        return search;
    }

    protected NumberFormat buildNumericValidation(final Text text, final int precision, final int scale) {
        final NumberFormat numbFormat = NumberFormat.getInstance();
        numbFormat.setMaximumIntegerDigits(precision - scale);
        numbFormat.setMaximumFractionDigits(scale);
        numbFormat.setMinimumFractionDigits(scale);
        ((DecimalFormat)numbFormat).setParseBigDecimal(true);
        text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.character != '.' && e.character != ',' && e.character != '+' && e.character != '-' && !Character.isDigit(e.character) && !Character.isISOControl(e.character)) {
                    e.doit = false;
                    return;
                }
            }
        });
        text.addModifyListener(new ModifyListener(){
            ParsePosition pp = new ParsePosition(0);

            public void modifyText(ModifyEvent e) {
                String ival = text.getText();
                if (ival.trim().isEmpty()) {
                    return;
                }
                this.pp.setIndex(0);
                this.pp.setErrorIndex(-1);
                BigDecimal val = (BigDecimal)numbFormat.parse(ival.trim(), this.pp);
                if (this.pp.getErrorIndex() >= 0 || val.precision() > precision || val.scale() > scale) {
                    text.setText(numbFormat.format(val));
                }
            }
        });
        return numbFormat;
    }
}

