/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.editingsupport;

import com.vela.videosupport.editingsupport.DBEditableValidator;
import com.vela.videosupport.editingsupport.EditableElement;
import com.vela.videosupport.editingsupport.IEditableValidator;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class EditableTextElement<A>
extends EditableElement<A> {
    protected final Text value;
    protected final Label description;
    protected final Class<A> resultType;
    protected final NumberFormat numFormat;
    protected final IEditableValidator<String>[] validators;
    protected DBEditableValidator<?> daoValidator;
    private boolean validated = false;

    public EditableTextElement(Text value, Label description, Class<A> resultType, NumberFormat numFormat, IEditableValidator<String>[] validators) {
        this.value = value;
        this.description = description;
        this.resultType = resultType;
        this.numFormat = numFormat;
        this.validators = validators;
        this.daoValidator = null;
        this.validated = false;
    }

    @Override
    public A getDBValue() {
        if (!this.validated) {
            throw new RuntimeException("Processo di validazione non completato, impossibile memorizzare");
        }
        if (this.daoValidator != null) {
            throw new RuntimeException("Occorre ritornare il dato come oggetto DB");
        }
        return this.parse(this.value.getText());
    }

    public <B> B getDBObject(Class<B> clz) {
        if (!this.validated) {
            throw new RuntimeException("Processo di validazione non completato, impossibile memorizzare");
        }
        if (this.daoValidator == null) {
            throw new RuntimeException("Occorre ritornare il dato come tipo primitivo");
        }
        return (B)this.daoValidator.getValidatedModel();
    }

    public A parse(String val) {
        if (this.numFormat != null) {
            ParsePosition pp = new ParsePosition(0);
            A result = this.castNumberResult(this.resultType, this.numFormat.parse(val, pp));
            if (pp.getErrorIndex() >= 0) {
                throw new RuntimeException(MessageFormat.format("Non \u00e8 stato possibile convertire {0} in un numero", val));
            }
            return result;
        }
        return this.resultType.cast(val);
    }

    private String format(A source) {
        if (this.numFormat != null) {
            try {
                return this.numFormat.format(source);
            }
            catch (IllegalArgumentException ie) {
                throw new RuntimeException(MessageFormat.format("Non \u00e8 stato possibile convertire il numero {0} in testo", source));
            }
        }
        return source.toString();
    }

    protected A castNumberResult(Class<A> type, Number result) {
        if (result.getClass().isAssignableFrom(type)) {
            return type.cast(result);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return (A)Long.valueOf(result.longValue());
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return (A)Double.valueOf(result.doubleValue());
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return (A)Float.valueOf(result.floatValue());
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return (A)Integer.valueOf(result.intValue());
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            return (A)Short.valueOf(result.shortValue());
        }
        if (Byte.TYPE.isAssignableFrom(type)) {
            return (A)Byte.valueOf(result.byteValue());
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return type.cast(new BigDecimal(result.toString()));
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return type.cast(new BigInteger(result.toString()));
        }
        return null;
    }

    public void setDaoValidator(DBEditableValidator<?> daoV) {
        this.daoValidator = daoV;
    }

    @Override
    public String validate() {
        String result;
        this.validated = false;
        String text = this.value.getText();
        IEditableValidator<String>[] iEditableValidatorArray = this.validators;
        int n = this.validators.length;
        int n2 = 0;
        while (n2 < n) {
            IEditableValidator<String> validator = iEditableValidatorArray[n2];
            String result2 = validator.validate(text);
            if (result2 != null) {
                return result2;
            }
            ++n2;
        }
        if (this.daoValidator != null && (result = this.daoValidator.validate(text)) != null) {
            return result;
        }
        this.validated = true;
        return null;
    }

    public <C> void loadDBValue(C source) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (source == null) {
            this.value.setText("");
            if (this.description != null) {
                this.description.setText("");
            }
            return;
        }
        Object val = source;
        if (this.daoValidator != null) {
            this.description.setText(this.daoValidator.getPrimaryDescription(source));
            val = this.daoValidator.getPrimaryKey(source);
        }
        this.value.setText(this.format(val));
    }

    public Text getValue() {
        return this.value;
    }

    @Override
    public void hookModifyListener(Listener listener) {
        this.value.addListener(24, listener);
    }

    @Override
    protected void setEnabled(boolean b) {
        this.value.setEditable(b);
    }
}

