/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.editingsupport;

import com.vela.videosupport.Activator;
import com.vela.videosupport.editingsupport.EditablePart;
import com.vela.videosupport.editingsupport.SaveAction;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class EditorPart
extends EditablePart {
    public static final String TRANSIENT_DATA_MODEL = "model";
    private Listener dirtyListener;
    protected Control dftControl;
    protected ResourceManager resManager;
    private ToolItem save;
    private Map<String, Composite> bodyFolders = new LinkedHashMap<String, Composite>();
    private Composite body;

    public EditorPart() {
        this.dirtyListener = l -> {
            this.getDirtyFlag().setDirty(true);
            this.save.setEnabled(true);
        };
    }

    protected abstract MApplication getApp();

    protected abstract EPartService getPartService();

    protected abstract MPart getPart();

    protected abstract EModelService getModelService();

    protected abstract MDirtyable getDirtyFlag();

    protected void buildHead(Composite parent, boolean update) {
        this.resManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.buildBar(parent);
        Composite header = new Composite(parent, 2048);
        header.setLayout((Layout)new GridLayout(4, false));
        header.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fillHeader(header);
        if (update) {
            this.uiElemets.forEach(e -> e.setEnabled(false));
        }
    }

    private void buildBar(Composite parent) {
        ToolBar top = new ToolBar(parent, 8388936);
        top.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Bundle bundle = FrameworkUtil.getBundle(Activator.class);
        this.save = new ToolItem(top, 8);
        this.save.setImage(this.resManager.createImage(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path("icons/save.png"), null))));
        this.save.setToolTipText("Salva le modifiche");
        this.save.setEnabled(false);
        this.save.addListener(13, l -> {
            if (this.getPartService().savePart(this.getPart(), false)) {
                this.getPartService().hidePart(this.getPart(), true);
            }
        });
        ToolItem exit = new ToolItem(top, 8);
        exit.setImage(this.resManager.createImage(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path("icons/exit.png"), null))));
        exit.setToolTipText("Esci senza salvare");
        exit.addListener(13, l -> {
            if (this.getDirtyFlag().isDirty() && !MessageDialog.openConfirm((Shell)parent.getShell(), (String)"Conferma uscita", (String)"Sono state effettuate delle modifiche, uscire senza salvare?")) {
                return;
            }
            this.getDirtyFlag().setDirty(false);
            this.getPartService().hidePart(this.getPart(), true);
        });
    }

    protected abstract void loadData();

    protected void hookEvents() {
        this.uiElemets.forEach(e -> e.hookModifyListener(this.dirtyListener));
    }

    protected abstract SaveAction saveData(MPart var1);

    protected abstract void fillHeader(Composite var1);

    protected void buildBody(Composite parent, boolean update, int columnsNo, String ... tabFolders) {
        final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 2816);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.body = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.body);
        this.body.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                scrolledComposite.setMinSize(EditorPart.this.body.computeSize(scrolledComposite.getClientArea().width, -1));
            }
        });
        this.body.setLayoutData((Object)new GridData(4, 4, true, true));
        if (tabFolders == null || tabFolders.length == 0) {
            this.body.setLayout((Layout)new GridLayout(4 * columnsNo, false));
        } else {
            this.body.setLayout((Layout)new GridLayout(1, false));
            TabFolder container = new TabFolder(this.body, 2048);
            container.setLayoutData((Object)new GridData(4, 4, true, true));
            container.setLayout((Layout)new GridLayout(1, false));
            String[] stringArray = tabFolders;
            int n = tabFolders.length;
            int n2 = 0;
            while (n2 < n) {
                String tabFolder = stringArray[n2];
                TabItem item = new TabItem(container, 0);
                item.setText(tabFolder);
                Composite part = new Composite((Composite)container, 0);
                GridLayout layout = new GridLayout(4 * columnsNo, false);
                part.setLayoutData((Object)new GridData(4, 128, true, false));
                part.setLayout((Layout)layout);
                item.setControl((Control)part);
                this.bodyFolders.put(tabFolder, part);
                ++n2;
            }
        }
        this.fillBody(this.body);
        scrolledComposite.setMinSize(this.body.computeSize(scrolledComposite.getClientArea().width, -1));
    }

    protected Composite getParentComposite(Composite base, String name) {
        if (!base.equals(this.body)) {
            return base;
        }
        if (this.bodyFolders.isEmpty()) {
            return base;
        }
        if (name == null || name.isEmpty() || !this.bodyFolders.containsKey(name)) {
            return this.bodyFolders.entrySet().iterator().next().getValue();
        }
        return this.bodyFolders.get(name);
    }

    protected abstract void fillBody(Composite var1);
}

