/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.editingsupport;

import com.vela.videosupport.ATableBuilder;
import com.vela.videosupport.editingsupport.IDescriptor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SearchDialog<A>
extends Dialog {
    private final Class<A> clazz;
    private final IDescriptor<A> descriptor;
    private A selection = null;

    protected SearchDialog(Shell parentShell, Class<A> clazz, IDescriptor<A> descriptor) {
        super(parentShell);
        this.clazz = clazz;
        this.descriptor = descriptor;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        try {
            ATableBuilder<A> table = ATableBuilder.get(container, this.descriptor, new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelection().isEmpty()) {
                        SearchDialog.this.selection = null;
                    }
                    SearchDialog.this.selection = ((StructuredSelection)event.getSelection()).getFirstElement();
                }
            }, this.clazz);
            table.init();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Errore", (String)(e.getMessage() != null ? e.getMessage() : e.toString()));
            e.printStackTrace();
        }
        return container;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.descriptor.getModelProvider().getListDescription());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(1000, 700);
    }

    public A getSelection() {
        return this.selection;
    }
}

