/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.filteringsupport;

import com.vela.videosupport.editingsupport.EditableElement;
import com.vela.videosupport.editingsupport.EditablePart;
import com.vela.videosupport.editingsupport.IEditableValidator;
import com.vela.videosupport.filteringsupport.FilterEvent;
import com.vela.videosupport.filteringsupport.FilterListener;
import com.vela.videosupport.nattablesupport.DataFilterOperatorType;
import com.vela.videosupport.support.TableColumnModel;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class FilterPart
extends EditablePart {
    private static final int DFT_NUM_PRECISION = 15;
    private static final int DFT_STRING_SIZE = 15;
    private List<Combo> comparations;
    private List<String> properties;
    private final List<FilterListener> filterListener = new ArrayList<FilterListener>();
    private ExpandItem item0;
    private Composite container;

    public void buildBody(final Composite container, Composite parent, List<TableColumnModel> filters) {
        this.container = container;
        parent.setLayout((Layout)new GridLayout(1, false));
        final ExpandBar bar = new ExpandBar(parent, 512);
        bar.setLayout((Layout)new GridLayout(2, false));
        bar.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite body = new Composite((Composite)bar, 0);
        body.setLayout((Layout)new GridLayout(6, false));
        body.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fillBody(body, filters);
        this.item0 = new ExpandItem(bar, 0, 0);
        this.item0.setText("Filtro avanzato");
        this.item0.setHeight(body.computeSize((int)-1, (int)-1).y);
        this.item0.setControl((Control)body);
        this.item0.setExpanded(false);
        bar.addExpandListener(new ExpandListener(){

            public void itemCollapsed(ExpandEvent e) {
                bar.getDisplay().asyncExec(() -> container.layout(true));
            }

            public void itemExpanded(ExpandEvent e) {
                bar.getDisplay().asyncExec(() -> container.layout(true));
            }
        });
    }

    protected void fillBody(Composite filterComp, List<TableColumnModel> filters) {
        this.comparations = new ArrayList<Combo>();
        this.properties = new ArrayList<String>();
        boolean first = true;
        DataFilterOperatorType[] operators = null;
        for (TableColumnModel filter : filters) {
            EditableElement element;
            Class<?> clazz = filter.getMethod().getReturnType();
            if (Calendar.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || LocalDateTime.class.isAssignableFrom(clazz) || LocalDate.class.isAssignableFrom(clazz) || LocalTime.class.isAssignableFrom(clazz) || OffsetDateTime.class.isAssignableFrom(clazz) || OffsetTime.class.isAssignableFrom(clazz)) {
                element = this.buildTemporalField(filterComp, filter.getLabel(), clazz, new IEditableValidator[0]);
                operators = new DataFilterOperatorType[]{DataFilterOperatorType.NONE, DataFilterOperatorType.EQ, DataFilterOperatorType.NE, DataFilterOperatorType.GE, DataFilterOperatorType.GT, DataFilterOperatorType.LE, DataFilterOperatorType.LT};
            } else if (Boolean.TYPE.isAssignableFrom(clazz)) {
                element = this.buildCheckboxField(filterComp, filter.getLabel(), new IEditableValidator[0]);
                operators = new DataFilterOperatorType[]{DataFilterOperatorType.NONE, DataFilterOperatorType.EQ, DataFilterOperatorType.NE};
            } else if (Number.class.isAssignableFrom(clazz)) {
                element = this.buildNumericField(filterComp, filter.getLabel(), filter.getSize() != 0 ? filter.getSize() : 15, filter.getScale(), clazz, new IEditableValidator[0]);
                operators = new DataFilterOperatorType[]{DataFilterOperatorType.NONE, DataFilterOperatorType.EQ, DataFilterOperatorType.NE, DataFilterOperatorType.GE, DataFilterOperatorType.GT, DataFilterOperatorType.LE, DataFilterOperatorType.LT};
            } else if (clazz.isEnum()) {
                element = this.buildComboboxField(filterComp, filter.getLabel(), clazz.asSubclass(Enum.class), new IEditableValidator[0]);
                operators = new DataFilterOperatorType[]{DataFilterOperatorType.NONE, DataFilterOperatorType.EQ, DataFilterOperatorType.NE};
            } else {
                element = this.buildTextField(filterComp, filter.getLabel(), filter.getSize() != 0 ? filter.getSize() : 15, new IEditableValidator[0]);
                operators = new DataFilterOperatorType[]{DataFilterOperatorType.NONE, DataFilterOperatorType.LIKE, DataFilterOperatorType.DEEP_LIKE, DataFilterOperatorType.EQ, DataFilterOperatorType.NE, DataFilterOperatorType.GE, DataFilterOperatorType.GT, DataFilterOperatorType.LE, DataFilterOperatorType.LT};
            }
            Combo combo = new Combo(filterComp, 12);
            combo.setLayoutData((Object)new GridData(1, 1, false, false));
            combo.setToolTipText("Tipo di relazione");
            int i = 0;
            while (i < operators.length) {
                combo.add(operators[i].toString());
                combo.setData(Integer.toString(i), (Object)operators[i]);
                ++i;
            }
            combo.select(0);
            this.comparations.add(combo);
            this.properties.add(filter.getPropertyPath());
            element.hookModifyListener(l -> {
                if (combo.getSelectionIndex() == 0) {
                    combo.select(1);
                }
            });
            if (first) {
                Bundle bundle = FrameworkUtil.getBundle(this.getClass());
                LocalResourceManager resManager = new LocalResourceManager(JFaceResources.getResources(), (Control)filterComp);
                first = false;
                Button filterB = new Button(filterComp, 8);
                filterB.setImage(resManager.createImage(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path("icons/search.png"), null))));
                filterB.setToolTipText("Applica il filtro");
                filterB.setLayoutData((Object)new GridData(4, 1, false, false));
                filterB.addListener(13, l -> this.applyFilter());
                continue;
            }
            new Label(filterComp, 0);
        }
    }

    private void applyFilter() {
        if (!this.validateUI()) {
            return;
        }
        FilterEvent fe = new FilterEvent();
        int i = 0;
        while (i < this.comparations.size()) {
            Combo cmp = this.comparations.get(i);
            DataFilterOperatorType op = (DataFilterOperatorType)((Object)cmp.getData(Integer.toString(cmp.getSelectionIndex())));
            if (op != null && op != DataFilterOperatorType.NONE) {
                EditableElement element = (EditableElement)this.uiElemets.get(i);
                fe.addFilter(this.properties.get(i), op, element.getDBValue());
            }
            ++i;
        }
        this.item0.setExpanded(false);
        this.container.layout(true);
        this.fireFilterEvent(fe);
    }

    public synchronized void addFilterListener(FilterListener listener) {
        this.filterListener.add(listener);
    }

    public synchronized void removeFilterListener(FilterListener listener) {
        this.filterListener.remove(listener);
    }

    protected synchronized void fireFilterEvent(FilterEvent event) {
        this.filterListener.forEach(f -> f.filterApplied(event));
    }
}

