/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.formatters;

import com.vela.videosupport.ValueFormatter;
import com.vela.videosupport.formatters.BigDecimalFormatter;
import com.vela.videosupport.formatters.BooleanFormatter;
import com.vela.videosupport.formatters.CalendarFormatter;
import com.vela.videosupport.formatters.DateFormatter;
import com.vela.videosupport.formatters.EnumFormatter;
import com.vela.videosupport.formatters.LocalDateFormatter;
import com.vela.videosupport.formatters.LocalDateTimeFormatter;
import com.vela.videosupport.formatters.LocalTimeFormatter;
import com.vela.videosupport.formatters.NumberFormatter;
import com.vela.videosupport.formatters.OffsetDateTimeFormatter;
import com.vela.videosupport.formatters.OffsetTimeFormatter;
import com.vela.videosupport.formatters.SimpleFormatter;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Formatters {
    private static final SimpleFormatter dftForm = new SimpleFormatter();
    private static final LocalDateFormatter locDateForm = new LocalDateFormatter();
    private static final LocalTimeFormatter locTimeForm = new LocalTimeFormatter();
    private static final LocalDateTimeFormatter locDateTimeForm = new LocalDateTimeFormatter();
    private static final OffsetTimeFormatter offTimeForm = new OffsetTimeFormatter();
    private static final OffsetDateTimeFormatter offDateTimeForm = new OffsetDateTimeFormatter();
    private static final CalendarFormatter dftCalForm = new CalendarFormatter();
    private static final DateFormatter dftDateForm = new DateFormatter();
    private static final BooleanFormatter dftBooleanForm = new BooleanFormatter();
    private static final Map<Integer, NumberFormatter> dftBigDecimalFormatters = new HashMap<Integer, NumberFormatter>();
    private static final Map<Integer, NumberFormatter> dftNbrFormatters = new HashMap<Integer, NumberFormatter>();
    private static final Map<Class<? extends Enum>, EnumFormatter> dftEnumFormatters = new HashMap<Class<? extends Enum>, EnumFormatter>();

    public static ValueFormatter get(Class<?> clazz, int scale) {
        if (Calendar.class.isAssignableFrom(clazz)) {
            return dftCalForm;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return dftDateForm;
        }
        if (LocalDateTime.class.isAssignableFrom(clazz)) {
            return locDateTimeForm;
        }
        if (LocalDate.class.isAssignableFrom(clazz)) {
            return locDateForm;
        }
        if (LocalTime.class.isAssignableFrom(clazz)) {
            return locTimeForm;
        }
        if (OffsetDateTime.class.isAssignableFrom(clazz)) {
            return offDateTimeForm;
        }
        if (OffsetTime.class.isAssignableFrom(clazz)) {
            return offTimeForm;
        }
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            return dftBooleanForm;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return dftBigDecimalFormatters.computeIfAbsent(scale, BigDecimalFormatter::new);
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return dftNbrFormatters.computeIfAbsent(scale, NumberFormatter::new);
        }
        if (clazz.isEnum()) {
            return dftEnumFormatters.computeIfAbsent(clazz.asSubclass(Enum.class), EnumFormatter::new);
        }
        return dftForm;
    }
}

