/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.formatters;

import com.vela.videosupport.ValueFormatter;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParsePosition;

public class NumberFormatter
implements ValueFormatter {
    protected final DecimalFormat numberFormat;

    NumberFormatter(int scale) {
        StringBuilder pattern = new StringBuilder("#,###");
        if (scale > 0) {
            pattern.append(".");
            int i = 0;
            while (i < scale) {
                pattern.append('0');
                ++i;
            }
        }
        this.numberFormat = new DecimalFormat(pattern.toString());
    }

    @Override
    public String format(Object source) {
        return source != null ? this.numberFormat.format(source) : "";
    }

    @Override
    public Object parse(String source) {
        ParsePosition pp = new ParsePosition(0);
        Number n = this.numberFormat.parse(source, pp);
        if (pp.getErrorIndex() >= 0) {
            throw new RuntimeException(MessageFormat.format("Valore inserito {0} non valido al carattere {1}", source, pp.getErrorIndex()));
        }
        return n;
    }
}

