/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.jfacesupport;

import java.util.List;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class DnDSortingSupport {
    public static void addDnDSortingSupport(final TableViewer tableViewer, final IModelManipulator modelManipulator) {
        DragSource dragSource = new DragSource(tableViewer.getControl(), 2);
        dragSource.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                event.doit = !tableViewer.getStructuredSelection().isEmpty();
            }

            public void dragSetData(DragSourceEvent event) {
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    LocalSelectionTransfer.getTransfer().setSelection((ISelection)tableViewer.getStructuredSelection());
                    LocalSelectionTransfer.getTransfer().setSelectionSetTime((long)(event.time & 0xFFFF));
                }
            }

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
                LocalSelectionTransfer.getTransfer().setSelectionSetTime(0L);
            }
        });
        DropTarget dropTarget = new DropTarget(tableViewer.getControl(), 2);
        dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        dropTarget.addDropListener((DropTargetListener)new ViewerDropAdapter((Viewer)tableViewer){

            public void dragEnter(DropTargetEvent event) {
                if (event.widget instanceof DropTarget) {
                    boolean isSameViewer = tableViewer.getControl().equals(((DropTarget)event.widget).getControl());
                    if (isSameViewer) {
                        event.detail = 2;
                        this.setSelectionFeedbackEnabled(false);
                        super.dragEnter(event);
                    } else {
                        event.detail = 0;
                    }
                } else {
                    event.detail = 0;
                }
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return true;
            }

            public boolean performDrop(Object target) {
                int location = this.determineLocation(this.getCurrentEvent());
                if (location == 1) {
                    if (modelManipulator.insertBefore(this.getCurrentTarget(), this.getSelectedElement())) {
                        tableViewer.refresh();
                        return true;
                    }
                } else if (location == 2 && modelManipulator.insertAfter(this.getCurrentTarget(), this.getSelectedElement())) {
                    tableViewer.refresh();
                    return true;
                }
                return false;
            }

            private Object[] getSelectedElement() {
                return ((IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection()).toArray();
            }

            protected int determineLocation(DropTargetEvent event) {
                if (!(event.item instanceof Item)) {
                    return 4;
                }
                Item item = (Item)event.item;
                Point coordinates = new Point(event.x, event.y);
                coordinates = this.getViewer().getControl().toControl(coordinates);
                Rectangle bounds = this.getBounds(item);
                if (bounds == null) {
                    return 4;
                }
                if (coordinates.y - bounds.y < this.getThreshold()) {
                    return 1;
                }
                if (bounds.y + bounds.height - coordinates.y < this.getThreshold()) {
                    return 2;
                }
                return 3;
            }

            protected int getThreshold() {
                return ((Table)this.getViewer().getControl()).getItemHeight() / 2;
            }
        });
    }

    public static interface IModelManipulator {
        public boolean insertBefore(Object var1, Object ... var2);

        public boolean insertAfter(Object var1, Object ... var2);
    }

    public static class ListDataManipulator<T>
    implements IModelManipulator {
        private List<T> fData;

        public ListDataManipulator(List<T> data) {
            this.fData = data;
        }

        @Override
        public boolean insertBefore(Object target, Object ... sources) {
            Object[] objectArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                Object source = objectArray[n2];
                this.fData.remove(source);
                ++n2;
            }
            int targetIndex = this.fData.indexOf(target);
            if (targetIndex >= 0) {
                int i = 0;
                Object[] objectArray2 = sources;
                int n3 = sources.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object source = objectArray2[n4];
                    this.fData.add(targetIndex + i++, source);
                    ++n4;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean insertAfter(Object target, Object ... sources) {
            Object[] objectArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                Object source = objectArray[n2];
                this.fData.remove(source);
                ++n2;
            }
            int targetIndex = this.fData.indexOf(target);
            if (targetIndex >= 0) {
                int i = 1;
                Object[] objectArray2 = sources;
                int n3 = sources.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object source = objectArray2[n4];
                    this.fData.add(targetIndex + i++, source);
                    ++n4;
                }
                return true;
            }
            return false;
        }

        public void updateData(List<T> data) {
            this.fData = data;
        }
    }
}

