/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.jfacetable;

import com.vela.videosupport.ATableBuilder;
import com.vela.videosupport.jfacesupport.FakeEditingSupport;
import com.vela.videosupport.jfacesupport.IFilterTextProvider;
import com.vela.videosupport.jfacesupport.IModelModifyListener;
import com.vela.videosupport.jfacetable.JFaceTableBuilderSupport;
import com.vela.videosupport.support.DftViewerComparator;
import com.vela.videosupport.support.DftViewerFilter;
import com.vela.videosupport.support.TableColumnModel;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class JFaceTableBuilder<T>
extends ATableBuilder<T> {
    private IFilterTextProvider filterProvider;
    private IModelModifyListener modifyListener;
    private final TableViewer viewer;
    private final JFaceTableBuilderSupport supportBuilder = new JFaceTableBuilderSupport();

    @Override
    public void init() {
        TableColumnLayout tl = null;
        DftViewerComparator comparator = null;
        boolean bl = this.autoSize = this.autoSize && this.viewer.getTable().getParent().getChildren().length == 1;
        if (this.autoSize) {
            tl = new TableColumnLayout();
            this.viewer.getTable().getParent().setLayout((Layout)tl);
        }
        if (this.sorted) {
            comparator = new DftViewerComparator(this.modelColumns);
            this.viewer.setComparator((ViewerComparator)comparator);
        }
        int i = 0;
        while (i < this.modelColumns.length) {
            if (this.modelColumns[i] != null) {
                this.buildColumn(this.modelColumns[i], comparator, i);
            }
            ++i;
        }
        if (this.filterColumns.length > 0) {
            if (this.filterProvider == null) {
                throw new RuntimeException("Sono state inserite delle colonne con filtro senza fornire un provider");
            }
            this.viewer.setFilters(new ViewerFilter[]{new DftViewerFilter(this.filterColumns, this.filterProvider)});
        }
        if (this.autoSize) {
            this.layoutColumns(tl);
        }
    }

    private void layoutColumns(TableColumnLayout tl) {
        TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tc = tableColumnArray[n2];
            tl.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(tc.getWidth(), tc.getWidth()));
            ++n2;
        }
    }

    private void buildColumn(TableColumnModel column, DftViewerComparator comparator, int columnIndex) {
        TableViewerColumn col = new TableViewerColumn(this.viewer, column.isRightAligned() ? 131072 : 0);
        if (column.getColumnSize() > 0) {
            col.getColumn().setWidth(column.getColumnSize());
        }
        col.getColumn().setResizable(true);
        col.getColumn().setMoveable(true);
        col.getColumn().setText(column.getLabel());
        ColumnLabelProvider clp = null;
        clp = (ColumnLabelProvider)this.supportBuilder.buildLabelProvider(this.viewer, column);
        col.setLabelProvider((CellLabelProvider)clp);
        if (column.isEditable()) {
            col.setEditingSupport(this.supportBuilder.buildEditingsupport(this.viewer, this.modifyListener, column));
        } else if (column.isSelectable()) {
            col.setEditingSupport((EditingSupport)new FakeEditingSupport(this.viewer, clp));
        }
        if (comparator != null) {
            col.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(col.getColumn(), columnIndex, comparator));
        }
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index, final DftViewerComparator comparator) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                comparator.setColumn(index);
                int dir = comparator.getDirection();
                JFaceTableBuilder.this.viewer.getTable().setSortDirection(dir);
                JFaceTableBuilder.this.viewer.getTable().setSortColumn(column);
                JFaceTableBuilder.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    public JFaceTableBuilder(TableViewer tableViewer, IFilterTextProvider filterProvider, IModelModifyListener modifyListener, Class<T> model, boolean disableFilter, boolean disableSort) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        this.viewer = tableViewer;
        this.filterProvider = filterProvider;
        this.modifyListener = modifyListener;
        this.disableFilter = disableFilter;
        this.disableSort = disableSort;
        this.initModel(model);
    }
}

