/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.jfacetree;

import com.vela.videosupport.jfacesupport.IModelModifyListener;
import com.vela.videosupport.support.TableColumnModel;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

class JFaceTreeBuilderSupport {
    JFaceTreeBuilderSupport() {
    }

    public EditingSupport buildEditingsupport(TreeViewer table, IModelModifyListener modifyListener, TableColumnModel model) {
        return new DftEditingSupport(table, modifyListener, model);
    }

    public CellLabelProvider buildLabelProvider(final TreeViewer viewer, final TableColumnModel model) {
        return new ColumnLabelProvider(){

            public String getText(Object element) {
                return model.getElementTextValue(element);
            }

            public Color getBackground(Object element) {
                int c = 0;
                if (model.getColorProvider() != null && viewer != null) {
                    c = model.getColorProvider().getBackground(element);
                }
                if (c != 0) {
                    try {
                        return viewer.getTree().getDisplay().getSystemColor(c);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return super.getBackground(element);
            }

            public Color getForeground(Object element) {
                int c = 0;
                if (model.getColorProvider() != null && viewer != null) {
                    c = model.getColorProvider().getForeground(element);
                }
                if (c != 0) {
                    try {
                        return viewer.getTree().getDisplay().getSystemColor(c);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return super.getForeground(element);
            }
        };
    }

    class DftEditingSupport
    extends EditingSupport {
        private CellEditor editor;
        private boolean directValue;
        private final TreeViewer viewer;
        private final TableColumnModel model;
        private final IModelModifyListener modifyListener;
        private Pattern pattern;

        public DftEditingSupport(TreeViewer viewer, IModelModifyListener modifyListener, TableColumnModel model) {
            super((ColumnViewer)viewer);
            this.editor = null;
            this.directValue = false;
            this.pattern = null;
            this.viewer = viewer;
            this.modifyListener = modifyListener;
            this.model = model;
            if (model.getRegExValidator() != null && !model.getRegExValidator().isEmpty()) {
                this.pattern = Pattern.compile(model.getRegExValidator());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CellEditor getCellEditor(Object element) {
            if (this.editor == null) {
                DftEditingSupport dftEditingSupport = this;
                synchronized (dftEditingSupport) {
                    if (this.model.getMethod().getReturnType().isEnum()) {
                        Enum[] vals = this.model.getMethod().getReturnType().asSubclass(Enum.class).getEnumConstants();
                        List<String> sVals = Arrays.asList(vals).stream().map(e -> e.toString()).collect(Collectors.toList());
                        ComboBoxViewerCellEditor cce = new ComboBoxViewerCellEditor((Composite)this.viewer.getTree());
                        this.editor = cce;
                        cce.setLabelProvider((IBaseLabelProvider)new LabelProvider());
                        cce.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                        cce.setInput((Object)sVals.toArray(new String[0]));
                    } else if (Boolean.TYPE.isAssignableFrom(this.model.getMethod().getReturnType())) {
                        this.editor = new CheckboxCellEditor((Composite)this.viewer.getTree());
                        this.directValue = true;
                    } else {
                        this.editor = new TextCellEditor((Composite)this.viewer.getTree());
                    }
                }
                if (this.pattern != null) {
                    this.editor.setValidator(new ICellEditorValidator(){

                        public String isValid(Object value) {
                            if (value == null || value.toString().isEmpty()) {
                                return null;
                            }
                            if (DftEditingSupport.this.pattern.matcher(value.toString()).matches()) {
                                return null;
                            }
                            return "Campo non valido";
                        }
                    });
                }
            }
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return this.model.isEditable() || this.model.isSelectable();
        }

        protected Object getValue(Object element) {
            if (element == null) {
                return null;
            }
            return this.directValue ? this.model.getRawValue(element) : this.model.getValueFormatter().format(this.model.getRawValue(element));
        }

        protected void setValue(Object element, Object value) {
            try {
                if (this.modifyListener != null) {
                    element = this.modifyListener.modelRefresh(element);
                }
                if (value == null) {
                    this.model.setRawValue(element, null);
                } else {
                    this.model.setRawValue(element, this.directValue ? value : this.model.getValueFormatter().parse(value.toString()));
                }
                if (this.modifyListener != null) {
                    this.modifyListener.modelUpdate(element);
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.viewer.getTree().getShell(), (String)"Errore", (String)(e.getMessage() != null ? e.getMessage() : e.toString()));
            }
            this.viewer.update(element, null);
        }
    }
}

