/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.nattable;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import com.vela.videosupport.nattable.ReactiveSliderScroller;
import com.vela.videosupport.nattablesupport.IDataProvider;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.RowSelectionProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.IScroller;
import org.eclipse.nebula.widgets.nattable.viewport.SliderScroller;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.nebula.widgets.nattable.widget.WaitDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

class BodyLayerStack<A>
extends AbstractLayerTransform {
    private final FilterList<A> filterList;
    private final SortedList<A> sortedList;
    private final TransformedList<A, A> dataList;
    private final ListDataProvider<A> bodyDataProvider;
    private final DataLayer bodyDataLayer;
    private final ViewportLayer viewportLayer;
    private final SelectionLayer selectionLayer;
    private final ISelectionProvider selectionProvider;
    private final IDataProvider<A> dataProvider;
    private final Shell shell;
    private WaitDialog dialog;

    public BodyLayerStack(IDataProvider<A> dataProvider, IColumnPropertyAccessor<A> columnPropertyAccessor, Shell shell) {
        this.dataProvider = dataProvider;
        this.shell = shell;
        EventList eventList = GlazedLists.eventList(new ArrayList());
        this.dataList = GlazedLists.threadSafeList((EventList)eventList);
        this.loadData(false);
        this.sortedList = new SortedList(this.getDataList(), null);
        this.filterList = new FilterList(this.getSortedList());
        this.bodyDataProvider = new ListDataProvider(this.filterList, columnPropertyAccessor);
        this.bodyDataLayer = new DataLayer(this.getBodyDataProvider());
        this.bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new ColumnLabelAccumulator());
        GlazedListsEventLayer glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)this.getBodyDataLayer(), this.filterList);
        ColumnReorderLayer columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)glazedListsEventLayer);
        ColumnHideShowLayer columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)columnReorderLayer);
        this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)columnHideShowLayer);
        this.selectionProvider = new RowSelectionProvider(this.selectionLayer, this.bodyDataProvider, false);
        this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.getSelectionLayer());
        this.setUnderlyingLayer((ILayer)this.viewportLayer);
    }

    public void hackSlider(final NatTable natTable, Composite parent) {
        final Slider slider = new Slider(parent, 512);
        final SliderScroller scroller = new SliderScroller(slider);
        slider.setLayoutData((Object)new GridData(1, 4, false, true));
        ReactiveSliderScroller rss = null;
        rss = new ReactiveSliderScroller(slider);
        this.viewportLayer.setVerticalScroller((IScroller)rss);
        rss.addScrollListener(new ReactiveSliderScroller.ScrollListener(){
            private int prvSelection = 0;

            @Override
            public void scroll(ReactiveSliderScroller.ScrollEvent event) {
                if (event.getSelection() > this.prvSelection) {
                    this.prvSelection = event.getSelection();
                    BodyLayerStack.this.loadData(false);
                }
            }
        });
        natTable.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                if (event.stateMask == SWT.MOD2) {
                    ScrollBar horizontal = natTable.getHorizontalBar();
                    horizontal.setSelection(horizontal.getSelection() - (event.count < 0 ? -1 : 1) * horizontal.getIncrement());
                    BodyLayerStack.this.viewportLayer.setOriginX(BodyLayerStack.this.viewportLayer.getMinimumOrigin().getX() + horizontal.getSelection());
                    int increment = BodyLayerStack.this.viewportLayer.getColumnCount() > 0 ? BodyLayerStack.this.viewportLayer.getColumnWidthByPosition(0) : 0;
                    int scrollIncrement = Math.min(increment, BodyLayerStack.this.viewportLayer.getClientAreaWidth() / 4);
                    horizontal.setIncrement(scrollIncrement);
                } else {
                    slider.setSelection(slider.getSelection() - (event.count < 0 ? -1 : 1) * slider.getIncrement());
                    BodyLayerStack.this.viewportLayer.setOriginY(BodyLayerStack.this.viewportLayer.getMinimumOrigin().getY() + scroller.getSelection());
                    int increment = BodyLayerStack.this.viewportLayer.getRowCount() > 0 ? BodyLayerStack.this.viewportLayer.getRowHeightByPosition(0) : 0;
                    int scrollIncrement = Math.min(increment, BodyLayerStack.this.viewportLayer.getClientAreaHeight() / 4);
                    scroller.setIncrement(scrollIncrement);
                }
                event.doit = false;
            }
        });
    }

    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public FilterList<A> getFilterList() {
        return this.filterList;
    }

    public ListDataProvider<A> getBodyDataProvider() {
        return this.bodyDataProvider;
    }

    public DataLayer getBodyDataLayer() {
        return this.bodyDataLayer;
    }

    public SortedList<A> getSortedList() {
        return this.sortedList;
    }

    public ViewportLayer getViewportLayer() {
        return this.viewportLayer;
    }

    protected CompletableFuture<Boolean> loadData(boolean all) {
        this.buildDialog();
        return CompletableFuture.supplyAsync(() -> {
            String wait = "Dati in corso di caricamento ....";
            this.shell.getDisplay().asyncExec(() -> this.dialog.open());
            this.dataProvider.loadData(d -> {
                try {
                    this.shell.getDisplay().asyncExec(() -> {
                        try {
                            this.dialog.setMsg(String.valueOf(wait) + d.size());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.getDataList().addAll((Collection)d);
            }, all);
            this.shell.getDisplay().asyncExec(() -> this.dialog.close());
            return true;
        }).exceptionally(t -> {
            this.shell.getDisplay().syncExec(() -> {
                MessageDialog.openError((Shell)this.shell, (String)"Errore in fase di caricamento dati", (String)MessageFormat.format("Si \u00e8 verificato l''errore {0} in reperimento dati", t.getMessage() != null ? t.getMessage() : t.toString()));
                t.printStackTrace();
                try {
                    this.dialog.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            return false;
        });
    }

    private void buildDialog() {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/waiting.gif"), null);
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        this.dialog = new WaitDialog(this.shell, 0, "Dati in corso di caricamento ....", imageDescriptor.createImage());
        this.dialog.setBlockOnOpen(true);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public TransformedList<A, A> getDataList() {
        return this.dataList;
    }
}

