/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.nattable;

import com.vela.videosupport.nattable.BodyLayerStack;
import com.vela.videosupport.support.TableColumnModel;
import java.util.LinkedHashMap;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.ComboBoxFilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.ComboBoxFilterIconPainter;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.ComboBoxFilterRowConfiguration;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;

class HeaderLayerStack<A>
extends AbstractLayerTransform {
    private final IDataProvider columnHeaderDataProvider;

    public HeaderLayerStack(IColumnPropertyAccessor<A> columnPropertyAccessor, ConfigRegistry configRegistry, BodyLayerStack<A> bodyLayerStack, TableColumnModel[] model, boolean sorted, boolean filtered) {
        LinkedHashMap<String, String> propsToLabel = new LinkedHashMap<String, String>();
        TableColumnModel[] tableColumnModelArray = model;
        int n = model.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumnModel tcm = tableColumnModelArray[n2];
            propsToLabel.put(tcm.getPropertyPath(), tcm.getLabel());
            ++n2;
        }
        String[] props = propsToLabel.keySet().toArray(new String[model.length]);
        this.columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(props, propsToLabel);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer(this.columnHeaderDataProvider);
        ColumnHeaderLayer lastLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, bodyLayerStack, bodyLayerStack.getSelectionLayer());
        if (sorted) {
            lastLayer = new SortHeaderLayer((ILayer)lastLayer, (ISortModel)new GlazedListsSortModel(bodyLayerStack.getSortedList(), columnPropertyAccessor, (IConfigRegistry)configRegistry, (ILayer)columnHeaderDataLayer));
        }
        if (filtered) {
            ComboBoxFilterRowHeaderComposite filterRowHeaderLayer = new ComboBoxFilterRowHeaderComposite(bodyLayerStack.getFilterList(), (ILayer)bodyLayerStack.getBodyDataLayer(), bodyLayerStack.getSortedList(), columnPropertyAccessor, (ILayer)lastLayer, this.columnHeaderDataProvider, (IConfigRegistry)configRegistry, false);
            FilterRowComboBoxDataProvider comboBoxDataProvider = filterRowHeaderLayer.getComboBoxDataProvider();
            filterRowHeaderLayer.addConfiguration((IConfiguration)new ComboBoxFilterRowConfiguration((IComboBoxDataProvider)comboBoxDataProvider){
                {
                    this.cellEditor = new FilterRowComboBoxCellEditor(iComboBoxDataProvider, 5);
                    this.filterIconPainter = new ComboBoxFilterIconPainter(iComboBoxDataProvider, GUIHelper.getImage((String)"filter"), null);
                }
            });
            lastLayer = filterRowHeaderLayer;
        }
        this.setUnderlyingLayer((ILayer)lastLayer);
    }

    public IDataProvider getColumnHeaderDataProvider() {
        return this.columnHeaderDataProvider;
    }
}

