/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.nattable;

import com.vela.videosupport.ATableBuilder;
import com.vela.videosupport.editingsupport.IDescriptor;
import com.vela.videosupport.filteringsupport.FilterEvent;
import com.vela.videosupport.filteringsupport.FilterListener;
import com.vela.videosupport.filteringsupport.FilterPart;
import com.vela.videosupport.nattable.BodyLayerStack;
import com.vela.videosupport.nattable.ColumnPropertyAccessor;
import com.vela.videosupport.nattable.HeaderLayerStack;
import com.vela.videosupport.nattable.XSSFExcelExporter;
import com.vela.videosupport.nattablesupport.IModelEditorListener;
import com.vela.videosupport.support.TableColumnModel;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.config.NullComparator;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.ConversionFailedException;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.export.ExportConfigAttributes;
import org.eclipse.nebula.widgets.nattable.export.command.ExportCommand;
import org.eclipse.nebula.widgets.nattable.export.image.config.DefaultImageExportBindings;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.NatTableBorderOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.sort.SortConfigAttributes;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.theme.ModernNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class NatTableBuilder<T>
extends ATableBuilder<T> {
    private final Composite parent;
    private final IDescriptor<T> modelDescriptor;
    private final ISelectionChangedListener changeListener;
    private NatTable natTable;
    private BodyLayerStack<T> bodyLayerStack;
    private FilterPart filterPart;
    private FilterListener filterListener = new BoundFilterListener();

    public NatTableBuilder(Composite parent, IDescriptor<T> modelDescriptor, ISelectionChangedListener changeListener, Class<T> model) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        this.parent = parent;
        this.modelDescriptor = modelDescriptor;
        this.changeListener = changeListener;
        this.initModel(model);
    }

    @Override
    public void init() {
        LocalResourceManager resManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.parent);
        this.parent.setLayout((Layout)new GridLayout(2, false));
        ColumnPropertyAccessor columnPropertyAccessor = new ColumnPropertyAccessor(this.modelColumns);
        this.bodyLayerStack = new BodyLayerStack<T>(this.modelDescriptor.getModelProvider().getDataProvider(), columnPropertyAccessor, this.parent.getShell());
        ConfigRegistry configRegistry = new ConfigRegistry();
        HeaderLayerStack headerLayerStack = new HeaderLayerStack(columnPropertyAccessor, configRegistry, this.bodyLayerStack, this.modelColumns, this.sorted, this.filterColumns != null && this.filterColumns.length > 0);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(this.bodyLayerStack.getBodyDataProvider());
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        rowHeaderDataLayer.setDefaultColumnWidth(50);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, this.bodyLayerStack, this.bodyLayerStack.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider(headerLayerStack.getColumnHeaderDataProvider(), (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, headerLayerStack);
        GridLayer gridLayer = new GridLayer(this.bodyLayerStack, headerLayerStack, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        ToolBar top = new ToolBar(this.parent, 8388936);
        top.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.buildFilter(this.parent);
        this.natTable = new NatTable(this.parent, (ILayer)gridLayer, false);
        this.natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        this.natTable.addConfiguration((IConfiguration)new ModernNatTableThemeConfiguration());
        this.natTable.addOverlayPainter((IOverlayPainter)new NatTableBorderOverlayPainter());
        this.natTable.addConfiguration((IConfiguration)new AutoresizeStyle());
        if (this.sorted) {
            this.natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
            this.natTable.addConfiguration((IConfiguration)new ComparatorConfig());
        }
        this.natTable.addConfiguration((IConfiguration)new ExcelConfig());
        gridLayer.addConfiguration((IConfiguration)new DefaultImageExportBindings());
        this.natTable.addConfiguration((IConfiguration)new RowObjectTableConfig());
        this.natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(this.natTable){

            protected PopupMenuBuilder createCornerMenu(NatTable natTable) {
                return super.createCornerMenu(natTable).withStateManagerMenuItemProvider();
            }
        });
        this.natTable.configure();
        this.bodyLayerStack.hackSlider(this.natTable, this.parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.natTable);
        this.buildToolbar(top, (ResourceManager)resManager);
        IModelEditorListener mel = null;
        if (this.modelDescriptor.getModelProvider().getEditorProvider() != null) {
            this.handleDoubleClick();
            mel = new IModelEditorListener<T>(){

                @Override
                public void added(T obj) {
                    NatTableBuilder.this.bodyLayerStack.getDataList().add(obj);
                }

                @Override
                public void edited(T obj) {
                }

                @Override
                public void deleted(T obj) {
                    NatTableBuilder.this.bodyLayerStack.getDataList().remove(obj);
                }
            };
            this.modelDescriptor.getModelProvider().getEditorProvider().addModelEditorListener(mel);
        }
        if (this.changeListener != null) {
            this.bodyLayerStack.getSelectionProvider().addSelectionChangedListener(this.changeListener);
        }
        IModelEditorListener mel1 = mel;
        this.natTable.addDisposeListener(d -> {
            if (mel1 != null) {
                this.modelDescriptor.getModelProvider().getEditorProvider().removeModelEditorListener(mel1);
            }
            this.modelDescriptor.getModelProvider().getDataProvider().close();
            if (this.changeListener != null) {
                this.bodyLayerStack.getSelectionProvider().removeSelectionChangedListener(this.changeListener);
            }
            this.filterPart.removeFilterListener(this.filterListener);
        });
    }

    private void buildFilter(Composite base) {
        Composite filter = new Composite(base, 0);
        filter.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.filterPart = new FilterPart();
        this.filterPart.buildBody(this.parent, filter, Arrays.stream(this.modelColumns).filter(t -> t.isMain()).collect(Collectors.toList()));
        this.filterPart.addFilterListener(this.filterListener);
    }

    private void handleDoubleClick() {
        this.natTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                int rowPos = NatTableBuilder.this.natTable.getRowPositionByY(e.y);
                int bodyRowPos = LayerUtil.convertRowPosition((ILayer)NatTableBuilder.this.natTable, (int)rowPos, (IUniqueIndexLayer)NatTableBuilder.this.bodyLayerStack.getBodyDataLayer());
                Object object = NatTableBuilder.this.bodyLayerStack.getBodyDataProvider().getRowObject(bodyRowPos);
                NatTableBuilder.this.modelDescriptor.getModelProvider().getEditorProvider().edit(object);
            }
        });
    }

    private void buildToolbar(ToolBar top, ResourceManager resManager) {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (this.modelDescriptor.getModelProvider().isEditable() && this.modelDescriptor.getModelProvider().getEditorProvider() != null) {
            ToolItem add = new ToolItem(top, 8);
            add.setImage(resManager.createImage(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path("icons/add.png"), null))));
            add.setToolTipText("Creare un nuovo elemento");
            add.addListener(13, l -> this.modelDescriptor.getModelProvider().getEditorProvider().add());
            ToolItem edit = new ToolItem(top, 8);
            edit.setImage(resManager.createImage(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path("icons/edit.png"), null))));
            edit.setToolTipText("Modificare un elemento");
            edit.addListener(13, l -> this.edit(false));
            ToolItem delete = new ToolItem(top, 8);
            delete.setImage(resManager.createImage(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path("icons/delete.png"), null))));
            delete.setToolTipText("Rimuovere un elemento");
            delete.addListener(13, l -> this.edit(true));
        }
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/excel.png"), null);
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        ToolItem export = new ToolItem(top, 8);
        export.setImage(resManager.createImage(imageDescriptor));
        export.setToolTipText("Esportare i dati in excel");
        export.addListener(13, l -> this.bodyLayerStack.loadData(true).thenRun(() -> this.parent.getDisplay().asyncExec(() -> {
            try {
                this.natTable.doCommand((ILayerCommand)new ExportCommand(this.natTable.getConfigRegistry(), this.natTable.getShell()));
            }
            catch (Exception t) {
                MessageDialog.openError((Shell)this.parent.getShell(), (String)"Errore in fase di caricamento dati", (String)MessageFormat.format("Si \u00e8 verificato l''errore {0} in reperimento dati", t.getMessage() != null ? t.getMessage() : t.toString()));
            }
        })));
    }

    private void edit(boolean delete) {
        ISelection selection = this.bodyLayerStack.getSelectionProvider().getSelection();
        if (selection.isEmpty()) {
            MessageDialog.openInformation((Shell)this.parent.getShell(), (String)"Attenzione", (String)"Occorre selezionare almeno un elemento per procedere");
        }
        if (delete && !MessageDialog.openQuestion((Shell)this.parent.getShell(), (String)"Attenzione", (String)"Procedere con l'eliminazione degli elementi selezionati?")) {
            return;
        }
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        for (Object obj : (StructuredSelection)selection) {
            if (delete) {
                this.modelDescriptor.getModelProvider().getEditorProvider().remove(obj);
                continue;
            }
            this.modelDescriptor.getModelProvider().getEditorProvider().edit(obj);
        }
        this.bodyLayerStack.getSelectionProvider().setSelection((ISelection)new StructuredSelection());
    }

    class AutoresizeStyle
    extends DefaultNatTableStyleConfiguration {
        AutoresizeStyle() {
            this.cellPainter = new PaddingDecorator((ICellPainter)new TextPainter(false, true, 0, true), 0, 2, 0, 2);
        }
    }

    class BoundFilterListener
    implements FilterListener {
        BoundFilterListener() {
        }

        @Override
        public void filterApplied(FilterEvent event) {
            NatTableBuilder.this.modelDescriptor.getModelProvider().getDataProvider().setFilters(event.getFilters());
            NatTableBuilder.this.bodyLayerStack.getDataList().clear();
            NatTableBuilder.this.bodyLayerStack.loadData(false);
        }
    }

    class ComparatorConfig
    extends AbstractRegistryConfiguration {
        ComparatorConfig() {
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            int i = 0;
            while (i < NatTableBuilder.this.modelColumns.length) {
                if (NatTableBuilder.this.modelColumns[i].isSortable()) {
                    configRegistry.registerConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, (Object)NatTableBuilder.this.modelColumns[i], DisplayMode.NORMAL, "COLUMN_" + i);
                } else {
                    configRegistry.registerConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, (Object)new NullComparator(), DisplayMode.NORMAL, "COLUMN_" + i);
                }
                ++i;
            }
        }
    }

    class ExcelConfig
    extends AbstractRegistryConfiguration {
        ExcelConfig() {
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            XSSFExcelExporter exporter = new XSSFExcelExporter();
            exporter.setApplyVerticalTextConfiguration(true);
            exporter.setApplyBackgroundColor(false);
            configRegistry.registerConfigAttribute(ExportConfigAttributes.EXPORTER, (Object)exporter);
            configRegistry.registerConfigAttribute(ExportConfigAttributes.DATE_FORMAT, (Object)"dd.MM.yyyy");
        }
    }

    class RowObjectTableConfig
    extends AbstractRegistryConfiguration {
        RowObjectTableConfig() {
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            int i = 0;
            while (i < NatTableBuilder.this.modelColumns.length) {
                final TableColumnModel mc = NatTableBuilder.this.modelColumns[i];
                DisplayConverter displayCnvt = null;
                displayCnvt = new DisplayConverter(){

                    public Object canonicalToDisplayValue(Object canonicalValue) {
                        if (canonicalValue == null) {
                            return "";
                        }
                        try {
                            return mc.getValueFormatter().format(canonicalValue);
                        }
                        catch (Exception e) {
                            throw new ConversionFailedException(e.getMessage() != null ? e.getMessage() : e.toString());
                        }
                    }

                    public Object displayToCanonicalValue(Object displayValue) {
                        if (displayValue == null) {
                            return null;
                        }
                        if (displayValue.toString().isEmpty()) {
                            return "";
                        }
                        try {
                            return mc.getValueFormatter().parse(displayValue.toString());
                        }
                        catch (Exception e) {
                            throw new ConversionFailedException(e.getMessage() != null ? e.getMessage() : e.toString());
                        }
                    }
                };
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)displayCnvt, DisplayMode.NORMAL, "COLUMN_" + i);
                Style style = new Style();
                style.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)(mc.isRightAligned() ? HorizontalAlignmentEnum.RIGHT : HorizontalAlignmentEnum.LEFT));
                style.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, (Object)VerticalAlignmentEnum.TOP);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, DisplayMode.NORMAL, "COLUMN_" + i);
                if (mc.isFilterable()) {
                    configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)displayCnvt, DisplayMode.EDIT, "FILTER_COLUMN_" + i);
                    configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, (Object)displayCnvt, DisplayMode.NORMAL, "FILTER_COLUMN_" + i);
                }
                if (!mc.isFilterable()) {
                    configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.NEVER_EDITABLE, DisplayMode.NORMAL, "FILTER_COLUMN_" + i);
                }
                ++i;
            }
        }
    }
}

