/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.nattable;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.viewport.SliderScroller;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Slider;

public class ReactiveSliderScroller
extends SliderScroller {
    private final List<ScrollListener> listeners = new ArrayList<ScrollListener>();
    private int prvSelectionFired = -1;

    public void setSelection(int value) {
        super.setSelection(value);
        this.fireScrollEvent(value);
    }

    public void setMaximum(int value) {
        super.setMaximum(value);
    }

    public synchronized void addScrollListener(ScrollListener sl) {
        this.listeners.add(sl);
    }

    public synchronized void removeScrollListener(ScrollListener sl) {
        this.listeners.remove(sl);
    }

    protected synchronized void fireScrollEvent(int selection) {
        if (selection <= this.prvSelectionFired) {
            return;
        }
        if ((double)((float)(selection + super.getThumb()) / (float)super.getMaximum()) > 0.8) {
            this.prvSelectionFired = selection;
            ScrollEvent se = new ScrollEvent(selection);
            this.listeners.forEach(l -> l.scroll(se));
        }
    }

    public ReactiveSliderScroller(Slider slider) {
        super(slider);
        this.boundEvents(slider);
    }

    private void boundEvents(final Slider slider) {
        slider.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private int prvSelection = -1;

            public void widgetSelected(SelectionEvent e) {
                if (slider.getSelection() != this.prvSelection) {
                    this.prvSelection = slider.getSelection();
                    ReactiveSliderScroller.this.fireScrollEvent(this.prvSelection);
                }
            }
        });
    }

    class ScrollEvent {
        private final int selection;

        ScrollEvent(int selection) {
            this.selection = selection;
        }

        public int getSelection() {
            return this.selection;
        }
    }

    static interface ScrollListener
    extends EventListener {
        public void scroll(ScrollEvent var1);
    }
}

