/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.nattable;

import com.vela.videosupport.nattable.PoiExcelExporter;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.nebula.widgets.nattable.export.FileOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.swt.graphics.Color;

public class XSSFExcelExporter
extends PoiExcelExporter {
    private Map<Color, XSSFColor> colorWb = new HashMap<Color, XSSFColor>();

    public XSSFExcelExporter() {
        super((IOutputStreamProvider)new FileOutputStreamProvider("table_export.xlsx", new String[]{"Foglio di lavoro di excel (*.xlsx)"}, new String[]{"*.xlsx"}));
    }

    public XSSFExcelExporter(IOutputStreamProvider outputStreamProvider) {
        super(outputStreamProvider);
    }

    @Override
    protected Workbook createWorkbook() {
        this.colorWb = new HashMap<Color, XSSFColor>();
        return new XSSFWorkbook();
    }

    @Override
    protected void setFillForegroundColor(CellStyle xlCellStyle, Color swtColor) {
        ((XSSFCellStyle)xlCellStyle).setFillForegroundColor(this.getWbColor(swtColor));
    }

    @Override
    protected void setFontColor(Font xlFont, Color swtColor) {
        ((XSSFFont)xlFont).setColor(this.getWbColor(swtColor));
    }

    private XSSFColor getWbColor(Color swtColor) {
        if (!this.colorWb.containsKey(swtColor)) {
            XSSFColor color = new XSSFColor(new byte[]{(byte)swtColor.getRed(), (byte)swtColor.getGreen(), (byte)swtColor.getBlue()}, ((XSSFWorkbook)this.xlWorkbook).getStylesSource().getIndexedColors());
            this.colorWb.put(swtColor, color);
        }
        return this.colorWb.get(swtColor);
    }
}

