/*
 * Decompiled with CFR 0.152.
 */
package com.vela.videosupport.support;

import com.vela.videosupport.ColorProvider;
import com.vela.videosupport.EditorValuesProvider;
import com.vela.videosupport.ValueFormatter;
import jakarta.persistence.Column;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.List;

public class TableColumnModel
implements Comparator<Object> {
    private Method method;
    private List<Method> descendentMethods;
    private String label;
    private boolean sortable;
    private boolean filterable;
    private boolean editable;
    private boolean selectable;
    private String regExValidator;
    private Method setMethod;
    private boolean main;
    private int size;
    private int scale;
    private int columnSize;
    private boolean rightAligned;
    private ValueFormatter valueFormatter;
    private ColorProvider colorProvider;
    private EditorValuesProvider editorValuesProvider;
    private Comparator valueComparator;
    private String propertyPath;

    public String getLabel() {
        return this.label;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public int getScale() {
        return this.scale;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public ValueFormatter getValueFormatter() {
        return this.valueFormatter;
    }

    public Comparator getValueComparator() {
        return this.valueComparator;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setColumnSize(int columnSize) {
        this.columnSize = columnSize;
    }

    public void setValueFormatter(ValueFormatter valueFormatter) {
        this.valueFormatter = valueFormatter;
    }

    public void setValueComparator(Comparator<?> valueComparator) {
        this.valueComparator = valueComparator;
    }

    public boolean isRightAligned() {
        return this.rightAligned;
    }

    public void setRightAligned(boolean rightAligned) {
        this.rightAligned = rightAligned;
    }

    @Override
    public int compare(Object e1, Object e2) {
        if (e1 == null && e2 == null) {
            return 0;
        }
        if (e1 == null) {
            return -1;
        }
        if (e2 == null) {
            return 1;
        }
        e1 = this.getRawValue(e1);
        e2 = this.getRawValue(e2);
        if (e1 == null && e2 == null) {
            return 0;
        }
        if (e1 == null) {
            return -1;
        }
        if (e2 == null) {
            return 1;
        }
        if (this.valueComparator != null) {
            return this.valueComparator.compare(e1, e2);
        }
        return ((Comparable)e1).compareTo(e2);
    }

    public Object getRawValue(Object obj) {
        try {
            obj = this.resolveObj(obj);
            if (obj == null) {
                return obj;
            }
            return this.method.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
            throw new RuntimeException(e1);
        }
    }

    public void setRawValue(Object obj, Object value) {
        try {
            this.getSetMethod().invoke(this.resolveObj(obj), value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1);
        }
    }

    private Object resolveObj(Object obj) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.descendentMethods == null || this.descendentMethods.size() == 0) {
            return obj;
        }
        for (Method m : this.descendentMethods) {
            if (obj == null) {
                return obj;
            }
            obj = m.invoke(obj, new Object[0]);
        }
        return obj;
    }

    public String getElementTextValue(Object element) {
        if (element == null) {
            return "";
        }
        return this.valueFormatter.format(this.getRawValue(element));
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    public void setFilterable(boolean filterable) {
        this.filterable = filterable;
    }

    public ColorProvider getColorProvider() {
        return this.colorProvider;
    }

    public void setColorProvider(ColorProvider colorProvider) {
        this.colorProvider = colorProvider;
    }

    public Method getSetMethod() {
        if (this.setMethod == null) {
            this.resolveSetMethod();
        }
        return this.setMethod;
    }

    private synchronized void resolveSetMethod() {
        try {
            this.setMethod = this.method.getDeclaringClass().getDeclaredMethod(this.getSetterName(), this.method.getReturnType());
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(MessageFormat.format("E'' stato attivato il supporto di editing ma il metodo di set non esiste o non corrisponde al getter {0}", this.method.getName()));
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public List<Method> getDescendentMethods() {
        return this.descendentMethods;
    }

    public void setDescendentMethods(List<Method> parentMethod) {
        this.descendentMethods = parentMethod;
    }

    public String getPropertyName() {
        return this.resolvePropertyName(this.method.getName());
    }

    private String resolvePropertyName(String getter) {
        if (getter == null || getter.isEmpty()) {
            return getter;
        }
        char[] cs = getter.toCharArray();
        int i = 0;
        while (i < cs.length) {
            if (Character.isUpperCase(cs[i]) || !Character.isAlphabetic(cs[i])) {
                return String.valueOf(getter.substring(i, i + 1).toLowerCase()) + getter.substring(i + 1);
            }
            ++i;
        }
        throw new RuntimeException(MessageFormat.format("Il nome metodo {0} non \u00e8 interpretabile come getter", getter));
    }

    public String getSetterName() {
        String prop = this.getPropertyName();
        if (prop == null || prop.isEmpty()) {
            return prop;
        }
        return "set" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
    }

    public String getPropertyPath() {
        if (this.propertyPath == null) {
            this.buildProperyPath();
        }
        return this.propertyPath;
    }

    private synchronized void buildProperyPath() {
        this.propertyPath = this.getPropertyName();
        if (this.descendentMethods == null || this.descendentMethods.size() == 0) {
            return;
        }
        for (Method m : this.descendentMethods) {
            this.propertyPath = String.valueOf(this.resolvePropertyName(m.getName())) + "." + this.propertyPath;
        }
    }

    public int getSize() {
        if (this.size == 0) {
            this.resolveSize();
        }
        return this.size;
    }

    private synchronized void resolveSize() {
        String prop = this.getPropertyName();
        Class<?> base = this.method.getDeclaringClass();
        try {
            Field fld = base.getDeclaredField(prop);
            Column col = fld.getAnnotation(Column.class);
            if (col != null && col.precision() != 0) {
                this.size = col.precision();
            } else if (col != null && col.length() != 0) {
                this.size = col.length();
            }
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(MessageFormat.format("L''attributo {0} non \u00e8 stato trovato", prop));
        }
    }

    public boolean isMain() {
        return this.main;
    }

    public void setMain(boolean main) {
        this.main = main;
    }

    public EditorValuesProvider getEditorValuesProvider() {
        return this.editorValuesProvider;
    }

    public void setEditorValuesProvider(EditorValuesProvider editorValuesProvider) {
        this.editorValuesProvider = editorValuesProvider;
    }

    public String getRegExValidator() {
        return this.regExValidator;
    }

    public void setRegExValidator(String regExValidator) {
        this.regExValidator = regExValidator;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }
}

