/*
 * Decompiled with CFR 0.152.
 */
package com.vela.common.db.converters;

import com.vela.common.db.converters.AVelaDBConverter;
import jakarta.persistence.Converter;

@Converter
public class SystemReverseBooleanConverter
extends AVelaDBConverter<Boolean, Number> {
    public Number convertToDatabaseColumn(Boolean input) {
        return (byte)(input == false ? 1 : 0);
    }

    public Boolean convertToEntityAttribute(Number input) {
        if (input == null || input.byteValue() == 1) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isApplicableTo(int sqlType, int size, int digits) {
        return this.isNumeric(sqlType) && (sqlType != 2 && sqlType != 3 || size == 1 && digits == 0);
    }

    @Override
    public Class<?> getResultClass() {
        return Boolean.TYPE;
    }
}

