/*
 * Decompiled with CFR 0.152.
 */
package com.vela.common.db.converters;

import com.vela.common.db.converters.AVelaDBConverter;
import com.vela.common.utils.DateHelper;
import jakarta.persistence.Converter;
import java.math.BigDecimal;
import java.time.LocalDate;

@Converter
public class XcondaLocalDateConverter
extends AVelaDBConverter<LocalDate, BigDecimal> {
    public BigDecimal convertToDatabaseColumn(LocalDate input) {
        if (input == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(DateHelper.toSystemDate((LocalDate)input));
    }

    public LocalDate convertToEntityAttribute(BigDecimal input) {
        if (input == null || input.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return DateHelper.fromSystemDateToLD((int)input.intValue());
    }

    @Override
    public boolean isApplicableTo(int sqlType, int size, int digits) {
        return (sqlType == 2 || sqlType == 3) && size == 6 && digits == 0;
    }

    @Override
    public Class<?> getResultClass() {
        return LocalDate.class;
    }
}

