/*
 * Decompiled with CFR 0.152.
 */
package com.vela.common.db.converters;

import com.vela.common.db.converters.AVelaDBConverter;
import com.vela.common.utils.DateHelper;
import jakarta.persistence.Converter;
import java.math.BigDecimal;

@Converter
public class XcondaYearConverter
extends AVelaDBConverter<Integer, BigDecimal> {
    public BigDecimal convertToDatabaseColumn(Integer input) {
        if (input == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(DateHelper.toSystemYear((Integer)input).toString());
    }

    public Integer convertToEntityAttribute(BigDecimal input) {
        if (input == null || input.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return DateHelper.fromSystemYear((int)input.intValue());
    }

    @Override
    public boolean isApplicableTo(int sqlType, int size, int digits) {
        return (sqlType == 2 || sqlType == 3) && size == 2 && digits == 0;
    }

    @Override
    public Class<?> getResultClass() {
        return Integer.TYPE;
    }
}

