/*
 * Decompiled with CFR 0.152.
 */
package com.vela.common.db.internal;

import com.vela.common.db.IDBManager;
import com.vela.common.db.internal.DBProperties;
import java.util.Objects;

class DBParms {
    private final IDBManager.DBType type;
    private final String persistenceUnit;
    private final String forcedSchema;
    private final ClassLoader cl;
    private DBProperties properties;

    DBParms(IDBManager.DBType type, ClassLoader cl, String persistenceUnit, String forcedSchema) {
        this.type = type;
        this.persistenceUnit = persistenceUnit;
        this.cl = cl;
        this.forcedSchema = forcedSchema;
    }

    public DBProperties getProperties() {
        if (this.properties == null) {
            this.properties = DBProperties.get(this.type);
        }
        this.properties.setForcedSchema(this.forcedSchema);
        return this.properties;
    }

    public IDBManager.DBType getType() {
        return this.type;
    }

    public String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.forcedSchema, this.persistenceUnit, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DBParms other = (DBParms)obj;
        return Objects.equals(this.forcedSchema, other.forcedSchema) && Objects.equals(this.persistenceUnit, other.persistenceUnit) && this.type == other.type;
    }

    public ClassLoader getCl() {
        return this.cl;
    }

    public String getForcedSchema() {
        return this.forcedSchema;
    }
}

