/*
 * Decompiled with CFR 0.152.
 */
package com.vela.common.db.internal;

import com.vela.common.db.IDBManager;
import com.vela.common.db.internal.PropertiesChooserUI;
import com.vela.common.db.internal.PropertiesMgr;
import com.vela.common.db.internal.PropertiesUI;
import com.vela.common.db.internal.db2.DB2Properties;
import com.vela.common.db.internal.mysql.MySqlProperties;
import com.vela.common.db.internal.sqlserver.SqlserverProperties;
import com.vela.common.utils.DateHelper;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.prefs.Preferences;

public abstract class DBProperties {
    protected String host;
    protected String user;
    protected String password;
    protected String schema;
    protected String forcedSchema;
    protected String commonSchema;
    private boolean xconda;
    private String printer;
    private String printerPc;
    protected boolean init = false;
    protected boolean retry = false;
    private static final String REBUILD_PROPERTY = "com.vela.db.update";

    protected abstract String getJdbcURL();

    protected abstract IDBManager.DBType getDBType();

    protected boolean isRebuildDB() {
        return Boolean.parseBoolean(System.getProperty(REBUILD_PROPERTY, "false"));
    }

    protected boolean getProperties() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("com.vela.common.db." + (Object)((Object)this.getDBType()));
        PropertiesMgr propMgr = new PropertiesMgr((Preferences)preferences);
        if (this.retry && !propMgr.intAccess) {
            System.err.println("Non \u00e8 stato possibile ottenere un accesso valido il sistema attender\u00e0 10 secondi prima di effettuare un nuovo tentativo");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.retry = false;
        }
        if (!this.retry && propMgr.autologon && propMgr.dbConnections.size() > 1) {
            this.chooseProperties(propMgr);
        }
        if (!(!this.retry && propMgr.autologon && propMgr.actConnection != null || this.initProperties(propMgr))) {
            return false;
        }
        this.retry = false;
        this.setHost(propMgr.actConnection.host);
        this.setUser(propMgr.actConnection.user);
        this.setPassword(propMgr.actConnection.password);
        this.setSchema(propMgr.actConnection.schema);
        this.setCommonSchema(propMgr.actConnection.commonSchema);
        this.setPrinter(propMgr.actConnection.printer);
        this.setXconda(propMgr.actConnection.xconda);
        DateHelper.init((boolean)propMgr.actConnection.xconda);
        this.setPrinterPc(propMgr.printerpc);
        return true;
    }

    protected boolean initProperties(PropertiesMgr propMgr) {
        if (Display.getCurrent() != null) {
            PropertiesUI pui = new PropertiesUI((Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault()).getActiveShell(), propMgr, this.getDBType(), this.retry);
            return pui.open() == 0;
        }
        if (Display.getDefault() != null) {
            Display d = Display.getDefault();
            class ICR
            implements Runnable {
                public boolean status = false;
                private final /* synthetic */ PropertiesMgr val$propMgr;

                ICR(PropertiesMgr propertiesMgr) {
                    this.val$propMgr = propertiesMgr;
                }

                @Override
                public void run() {
                    PropertiesUI pui = new PropertiesUI((Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault()).getActiveShell(), this.val$propMgr, DBProperties.this.getDBType(), DBProperties.this.retry);
                    this.status = pui.open() == 0;
                }
            }
            ICR icr = new ICR(propMgr);
            d.syncExec((Runnable)icr);
            return icr.status;
        }
        throw new RuntimeException("Impossibile avviare in modo corretto il la richiesta delle propriet\u00e0 a video");
    }

    protected boolean chooseProperties(PropertiesMgr propMgr) {
        if (Display.getCurrent() != null) {
            PropertiesChooserUI pui = new PropertiesChooserUI((Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault()).getActiveShell(), propMgr);
            return pui.open() == 0;
        }
        if (Display.getDefault() != null) {
            Display d = Display.getDefault();
            class ICR
            implements Runnable {
                public boolean status = false;
                private final /* synthetic */ PropertiesMgr val$propMgr;

                ICR(PropertiesMgr propertiesMgr) {
                    this.val$propMgr = propertiesMgr;
                }

                @Override
                public void run() {
                    PropertiesChooserUI pui = new PropertiesChooserUI((Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault()).getActiveShell(), this.val$propMgr);
                    this.status = pui.open() == 0;
                }
            }
            ICR icr = new ICR(propMgr);
            d.syncExec((Runnable)icr);
            return icr.status;
        }
        throw new RuntimeException("Impossibile avviare in modo corretto il la richiesta delle propriet\u00e0 a video");
    }

    protected abstract String getJdbcDriver();

    protected boolean addDbParms(Map<String, Object> parms) {
        if (!this.init) {
            this.init = this.getProperties();
        }
        if (!this.init) {
            return false;
        }
        parms.put("jakarta.persistence.jdbc.driver", this.getJdbcDriver());
        parms.put("jakarta.persistence.jdbc.url", this.getJdbcURL());
        parms.put("jakarta.persistence.jdbc.user", this.getUser());
        parms.put("jakarta.persistence.jdbc.password", this.getPassword());
        if (this.isRebuildDB()) {
            parms.put("eclipselink.ddl-generation", "create-or-extend-tables");
            parms.put("eclipselink.persistencexml", "META-INF/persistence-build.xml");
        } else {
            parms.put("eclipselink.ddl-generation", "none");
        }
        parms.put("eclipselink.ddl-generation.output-mode", "database");
        parms.put("eclipselink.flush-clear.cache", "DropInvalidate");
        parms.put("jakarta.persistence.lock.timeout", "4000");
        parms.put("eclipselink.weaving", "static");
        return true;
    }

    public String getHost() {
        if (!this.init) {
            this.init = this.getProperties();
        }
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUser() {
        if (!this.init) {
            this.init = this.getProperties();
        }
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        if (!this.init) {
            this.init = this.getProperties();
        }
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSchema() {
        if (!this.init) {
            this.init = this.getProperties();
        }
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public static DBProperties get(IDBManager.DBType type) {
        switch (type) {
            case DB2: {
                return new DB2Properties();
            }
            case MYSQL: {
                return new MySqlProperties();
            }
            case SQLSERVER: {
                return new SqlserverProperties();
            }
        }
        throw new RuntimeException("Tipologia di DB non definita");
    }

    public String getCommonSchema() {
        if (!this.init) {
            this.init = this.getProperties();
        }
        return this.commonSchema;
    }

    public void setCommonSchema(String commonSchema) {
        this.commonSchema = commonSchema;
    }

    public boolean isXconda() {
        if (!this.init) {
            this.init = this.getProperties();
        }
        return this.xconda;
    }

    public void setXconda(boolean xconda) {
        this.xconda = xconda;
    }

    public String getPrinter() {
        if (!this.init) {
            this.init = this.getProperties();
        }
        return this.printer;
    }

    public void setPrinter(String printer) {
        this.printer = printer;
    }

    public String getPrinterPc() {
        if (!this.init) {
            this.init = this.getProperties();
        }
        return this.printerPc;
    }

    public void setPrinterPc(String printer) {
        this.printerPc = printer;
    }

    public void retry() {
        this.init = false;
        this.retry = true;
    }

    public String getForcedSchema() {
        return this.forcedSchema;
    }

    public void setForcedSchema(String forcedSchema) {
        this.forcedSchema = forcedSchema;
    }

    public String getDftSchema() {
        if (this.forcedSchema != null && !this.forcedSchema.isEmpty()) {
            return this.getForcedSchema();
        }
        return this.getSchema();
    }
}

