/*
 * Decompiled with CFR 0.152.
 */
package com.vela.common.db.internal;

import com.vela.common.db.IDBManager;
import com.vela.common.db.ProgramDefinition;
import com.vela.common.db.internal.DBParms;
import com.vela.common.db.internal.MergedClassLoader;
import com.vela.common.db.internal.db2.DB2CallManager;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={IDBManager.class}, property={"osgi.command.scope=test", "osgi.command.function=dbManager"})
public class JPADBManager
implements IDBManager {
    private Map<DBParms, EntityManagerFactory> factories = new HashMap<DBParms, EntityManagerFactory>();
    private Map<String, DB2CallManager> callManagers = new HashMap<String, DB2CallManager>();

    @Activate
    protected void activateService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivateService() {
        Map<DBParms, EntityManagerFactory> map = this.factories;
        synchronized (map) {
            this.factories.values().stream().filter(emf -> emf.isOpen()).forEach(f -> f.close());
            this.factories.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EntityManager getEntityManager(IDBManager.DBType type, ClassLoader cl, String persistenceUnit, String forcedSchema) {
        int i = 0;
        while (true) {
            try {
                DBParms parms = new DBParms(type, cl, persistenceUnit, forcedSchema);
                EntityManagerFactory emf = null;
                emf = this.factories.get(parms);
                if (emf != null) {
                    if (i <= 0) return emf.createEntityManager();
                }
                Map<DBParms, EntityManagerFactory> map = this.factories;
                synchronized (map) {
                    if (emf != null) {
                        parms.getProperties().retry();
                        emf.close();
                    }
                    if ((emf = this.buildFactory(parms)) == null) {
                        return null;
                    }
                    this.factories.put(parms, emf);
                    return emf.createEntityManager();
                }
            }
            catch (PersistenceException e) {
                if (++i <= 4) continue;
                throw e;
            }
            break;
        }
    }

    private EntityManagerFactory buildFactory(DBParms parms) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eclipselink.classloader", new MergedClassLoader(parms.getCl(), this.getClass().getClassLoader()));
        if (!parms.getProperties().addDbParms(map)) {
            return null;
        }
        PersistenceProvider persistenceProvider = new PersistenceProvider();
        return persistenceProvider.createEntityManagerFactory(parms.getPersistenceUnit(), map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean call(IDBManager.DBType type, ProgramDefinition pgmDef, String defaultSchema) {
        if (type != IDBManager.DBType.DB2) {
            throw new RuntimeException("Operazione possibile solo per DB2");
        }
        if (!this.callManagers.containsKey(defaultSchema)) {
            JPADBManager jPADBManager = this;
            synchronized (jPADBManager) {
                this.callManagers.put(defaultSchema, new DB2CallManager(type, defaultSchema));
            }
        }
        return this.callManagers.get(defaultSchema).call(pgmDef);
    }

    @Override
    public String getConnectionUser(IDBManager.DBType type) {
        try {
            return this.getDftConnection(type).getProperties().getUser();
        }
        catch (PersistenceException e) {
            return "";
        }
    }

    @Override
    public String getConnectionSchema(IDBManager.DBType type) {
        try {
            return this.getDftConnection(type).getProperties().getSchema();
        }
        catch (PersistenceException e) {
            return "";
        }
    }

    private DBParms getDftConnection(IDBManager.DBType type) {
        Optional<DBParms> o = this.factories.keySet().stream().filter(p -> p.getType() == type).findFirst();
        if (o.isPresent()) {
            return o.get();
        }
        return new DBParms(type, this.getClass().getClassLoader(), "main", null);
    }
}

