/*
 * Decompiled with CFR 0.152.
 */
package com.vela.common.db.internal;

import com.vela.common.db.internal.PropertiesMgr;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PropertiesChooserUI
extends TitleAreaDialog {
    private Combo cmbList;
    private final PropertiesMgr preferences;

    public PropertiesChooserUI(Shell parentShell, PropertiesMgr preferences) {
        super(parentShell);
        this.preferences = preferences;
    }

    public void create() {
        super.create();
        this.setTitle("Scelta della connessione");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.createList(container);
        this.setData();
        if (this.preferences.actConnection != null) {
            this.cmbList.setText(this.preferences.actConnection.name);
        } else {
            this.cmbList.select(0);
        }
        return area;
    }

    private void createList(Composite container) {
        Label l = new Label(container, 0);
        l.setText("Nome connessione");
        this.cmbList = new Combo(container, 12);
        this.cmbList.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    protected void setData() {
        String[] items = this.preferences.dbConnections.keySet().toArray(new String[0]);
        if (items.length > 0) {
            this.cmbList.setItems(items);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        PropertiesMgr.DBConnParms parms = this.preferences.dbConnections.get(this.cmbList.getText());
        if (parms == null) {
            this.setMessage("Occorre selezionare la connessione", 3);
            return;
        }
        this.preferences.actConnection = parms;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.preferences.autologon = false;
        super.cancelPressed();
    }
}

