/*
 * Decompiled with CFR 0.152.
 */
package com.vela.common.db.internal;

import com.vela.common.utils.APreferences;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

class PropertiesMgr
extends APreferences {
    private final Preferences prefs;
    boolean autologon;
    boolean intAccess;
    String printerpc;
    final Map<String, DBConnParms> dbConnections = new LinkedHashMap<String, DBConnParms>();
    DBConnParms actConnection;

    public PropertiesMgr(Preferences prefs) {
        this.prefs = prefs;
        this.init();
    }

    private void init() {
        String[] connections = this.prefs.get("connections", "").split(",");
        this.autologon = this.prefs.getBoolean("autologon", false);
        this.intAccess = this.prefs.getBoolean("intAccess", false);
        this.printerpc = this.prefs.get("printerpc", null);
        String[] stringArray = connections;
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            String cnt = stringArray[n2];
            if (!cnt.isEmpty()) {
                DBConnParms dbc = new DBConnParms(cnt);
                dbc.host = this.prefs.get(String.valueOf(cnt) + ".host", "");
                dbc.user = this.prefs.get(String.valueOf(cnt) + ".user", "");
                dbc.password = this.encoder.decrypt(this.prefs.get(String.valueOf(cnt) + ".password", ""));
                dbc.schema = this.prefs.get(String.valueOf(cnt) + ".schema", "");
                dbc.commonSchema = this.prefs.get(String.valueOf(cnt) + ".commonSchema", "");
                dbc.printer = this.prefs.get(String.valueOf(cnt) + ".printer", System.getProperty("com.vela.common.outq", ""));
                dbc.xconda = this.prefs.getBoolean(String.valueOf(cnt) + ".xconda", Boolean.valueOf(System.getProperty("com.vela.xconda", "true")).booleanValue());
                this.dbConnections.put(cnt, dbc);
            }
            ++n2;
        }
        this.actConnection = this.dbConnections.get(this.prefs.get("actParms", ""));
    }

    public void save() throws BackingStoreException {
        this.prefs.put("connections", this.dbConnections.keySet().stream().reduce("", (a, b) -> "".equals(a) ? b : String.valueOf(a) + "," + b));
        this.prefs.putBoolean("autologon", this.autologon);
        this.prefs.putBoolean("intAccess", this.intAccess);
        this.prefs.put("printerpc", this.printerpc == null ? "" : this.printerpc);
        if (this.actConnection != null) {
            this.prefs.put("actParms", this.actConnection.name);
        }
        for (DBConnParms parms : this.dbConnections.values()) {
            this.prefs.put(String.valueOf(parms.name) + ".host", parms.host);
            this.prefs.put(String.valueOf(parms.name) + ".user", parms.user);
            this.prefs.put(String.valueOf(parms.name) + ".password", this.encoder.encrypt(parms.password));
            this.prefs.put(String.valueOf(parms.name) + ".schema", parms.schema);
            this.prefs.put(String.valueOf(parms.name) + ".commonSchema", parms.commonSchema);
            this.prefs.put(String.valueOf(parms.name) + ".printer", parms.printer);
            this.prefs.putBoolean(String.valueOf(parms.name) + ".xconda", parms.xconda);
        }
        this.prefs.flush();
    }

    static class DBConnParms {
        final String name;
        String host;
        String user;
        String password;
        String schema;
        String commonSchema;
        String printer;
        boolean xconda;

        public DBConnParms(String name) {
            this.name = name;
        }
    }
}

