/*
 * Decompiled with CFR 0.152.
 */
package com.vela.common.db.internal;

import com.vela.common.db.IDBManager;
import com.vela.common.db.internal.PropertiesMgr;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class PropertiesUI
extends TitleAreaDialog {
    private Combo cmbList;
    private Text txtHost;
    private Text txtUser;
    private Text txtPassword;
    private Text txtSchema;
    private Text txtCommonSchema;
    private Text txtPrinter;
    private Button butXconda;
    private Button butAutologon;
    private Button butIntAccess;
    private String actConn;
    private Label lPrinter;
    private boolean noEvt = false;
    private final boolean retry;
    private final IDBManager.DBType type;
    private final PropertiesMgr preferences;

    public PropertiesUI(Shell parentShell, PropertiesMgr preferences, IDBManager.DBType type, boolean retry) {
        super(parentShell);
        this.preferences = preferences;
        this.type = type;
        this.retry = retry;
    }

    public void create() {
        super.create();
        this.setTitle("Parametri di connessione " + this.type.toString());
        if (this.retry) {
            this.setErrorMessage("Si \u00e8 verificato un problema in fase di accesso, verificare i parametri di connessione");
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(3, false);
        container.setLayout((Layout)layout);
        this.createList(container);
        this.createHost(container);
        this.createUser(container);
        this.createPassword(container);
        this.createSchema(container);
        this.createCommonSchema(container);
        this.createAutologon(container);
        this.createPrinter(container);
        this.createXconda(container);
        this.createIntAccess(container);
        this.actConn = this.preferences.actConnection != null ? this.preferences.actConnection.name : "";
        this.setData();
        return area;
    }

    private void createList(Composite container) {
        Label l = new Label(container, 0);
        l.setText("Nome connessione");
        this.cmbList = new Combo(container, 4);
        this.cmbList.setLayoutData((Object)new GridData(4, 0, true, false));
        this.cmbList.addModifyListener(e -> {
            if (this.noEvt) {
                return;
            }
            this.actConn = this.cmbList.getText();
            this.initData();
        });
        Button remove = new Button(container, 8);
        remove.setText("Cancella");
        remove.setToolTipText("Cancella la connessione corrente");
        remove.addListener(13, list -> {
            try {
                this.removeData();
                try {
                    this.cmbList.remove(this.actConn);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                this.actConn = "";
                this.initData();
            }
            catch (BackingStoreException e1) {
                this.setMessage(e1.getMessage(), 3);
            }
        });
    }

    private void createAutologon(Composite container) {
        this.butAutologon = new Button(container, 32);
        this.butAutologon.setText("Connessione automatica");
        this.butAutologon.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
    }

    private void createXconda(Composite container) {
        this.butXconda = new Button(container, 32);
        this.butXconda.setText("Date su sistema in formato compatto");
        this.butXconda.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        this.butXconda.setVisible(false);
    }

    private void createIntAccess(Composite container) {
        this.butIntAccess = new Button(container, 32);
        this.butIntAccess.setText("Programma ad accesso interattivo");
        this.butIntAccess.setToolTipText("Indicare se si desidera che eventuali errori di logon provochino la revisualizzazione della videata di accesso, NON impostare su server fattura elettronica");
        this.butIntAccess.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        this.butIntAccess.setVisible(false);
    }

    private void createPrinter(Composite container) {
        this.lPrinter = new Label(container, 0);
        this.lPrinter.setText("Stampante predefinita");
        this.lPrinter.setVisible(false);
        this.txtPrinter = new Text(container, 2048);
        this.txtPrinter.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.txtPrinter.setTextLimit(10);
        this.txtPrinter.setVisible(false);
    }

    protected void setData() {
        this.noEvt = true;
        String[] items = this.preferences.dbConnections.keySet().toArray(new String[0]);
        if (items.length > 0) {
            this.cmbList.setItems(items);
            this.cmbList.setText(this.actConn);
            this.initData();
        }
        this.noEvt = false;
    }

    private void initData() {
        PropertiesMgr.DBConnParms parms = this.preferences.dbConnections.get(this.actConn);
        this.txtHost.setText(parms != null ? parms.host : "");
        this.txtUser.setText(parms != null ? parms.user : "");
        this.txtPassword.setText(parms != null ? parms.password : "");
        this.txtSchema.setText(parms != null ? parms.schema : "");
        this.txtCommonSchema.setText(parms != null ? parms.commonSchema : "");
        this.butXconda.setSelection(parms != null ? parms.xconda : Boolean.valueOf(System.getProperty("com.vela.xconda", "true")));
        this.txtPrinter.setText(parms != null ? parms.printer : "");
        this.butIntAccess.setSelection(this.preferences.intAccess);
        this.butAutologon.setSelection(this.preferences.autologon);
    }

    private void createSchema(Composite container) {
        Label l = new Label(container, 0);
        l.setText("Libreria/Schema");
        this.txtSchema = new Text(container, 2048);
        this.txtSchema.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
    }

    private void createCommonSchema(Composite container) {
        Label l = new Label(container, 0);
        l.setText("Libreria/Schema Comune (opz)");
        this.txtCommonSchema = new Text(container, 2048);
        this.txtCommonSchema.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.txtCommonSchema.setToolTipText("Inserire in questo campo la libreria comune se prevista");
    }

    private void createPassword(Composite container) {
        Label l = new Label(container, 0);
        l.setText("Password");
        this.txtPassword = new Text(container, 0x400800);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
    }

    private void createHost(Composite container) {
        Label l = new Label(container, 0);
        l.setText("Host");
        this.txtHost = new Text(container, 2048);
        this.txtHost.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
    }

    private void createUser(Composite container) {
        Label l = new Label(container, 0);
        l.setText("Utente");
        this.txtUser = new Text(container, 2048);
        this.txtUser.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
    }

    protected boolean isResizable() {
        return true;
    }

    private void removeData() throws BackingStoreException {
        this.preferences.dbConnections.remove(this.actConn);
        this.actConn = "";
        this.setData();
    }

    private void saveData() throws BackingStoreException {
        PropertiesMgr.DBConnParms conn = this.preferences.dbConnections.computeIfAbsent(this.actConn, PropertiesMgr.DBConnParms::new);
        conn.host = this.txtHost.getText();
        conn.password = this.txtPassword.getText();
        conn.schema = this.txtSchema.getText();
        conn.commonSchema = this.txtCommonSchema.getText();
        conn.user = this.txtUser.getText();
        conn.printer = this.txtPrinter.getText();
        conn.xconda = this.butXconda.getSelection();
        this.preferences.actConnection = conn;
        this.preferences.autologon = this.butAutologon.getSelection();
        this.preferences.intAccess = this.butIntAccess.getSelection();
        this.preferences.save();
    }

    protected void okPressed() {
        if (!this.checkInput()) {
            return;
        }
        try {
            this.saveData();
        }
        catch (BackingStoreException e) {
            this.setMessage(e.getMessage(), 3);
            return;
        }
        super.okPressed();
    }

    protected boolean checkInput() {
        this.setMessage(null, 0);
        if (this.cmbList.getText().isEmpty()) {
            this.cmbList.setFocus();
            this.setMessage("Occorre indicare il nome della connessione", 3);
            return false;
        }
        if (this.txtHost.getText().isEmpty()) {
            this.txtHost.setFocus();
            this.setMessage("Occorre indicare l'host a cui connettersi", 3);
            return false;
        }
        if (this.txtUser.getText().isEmpty()) {
            this.txtUser.setFocus();
            this.setMessage("Occorre indicare l'utente", 3);
            return false;
        }
        if (this.txtPassword.getText().isEmpty()) {
            this.txtPassword.setFocus();
            this.setMessage("Occorre indicare la password", 3);
            return false;
        }
        if (this.txtSchema.getText().isEmpty()) {
            this.txtSchema.setFocus();
            this.setMessage("Occorre indicare la libreria/schema", 3);
            return false;
        }
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button adv = this.createButton(parent, 13, "Avanzate", false);
        adv.addListener(13, l -> {
            this.lPrinter.setVisible(true);
            this.txtPrinter.setVisible(true);
            this.butXconda.setVisible(true);
            this.butIntAccess.setVisible(true);
            adv.setEnabled(false);
        });
    }
}

