/*
 * Decompiled with CFR 0.152.
 */
package com.vela.common.db.internal.db2;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.vela.common.db.IDBManager;
import com.vela.common.db.ProgramDefinition;
import com.vela.common.db.internal.DBProperties;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;

public class DB2CallManager {
    private final DBProperties properties;
    private ProgramCall programCall = null;

    public DB2CallManager(IDBManager.DBType type, String defaultSchema) {
        this.properties = DBProperties.get(type);
        this.properties.setForcedSchema(defaultSchema);
    }

    public synchronized boolean call(ProgramDefinition pgmDef) {
        int i = 0;
        while (i < 2) {
            try {
                if (pgmDef.getCommand() != null) {
                    return this.commandCall(pgmDef);
                }
                if (this.programCall == null) {
                    this.programCall = this.init();
                }
                QSYSObjectPathName path = new QSYSObjectPathName(pgmDef.getLibrary(), pgmDef.getProgram(), "PGM");
                if (pgmDef.getParms() == null || pgmDef.getParms().length == 0) {
                    this.programCall.setProgram(path.getPath());
                    return this.programCall.run();
                }
                PgmParms pp = new PgmParms(pgmDef.getParms());
                this.programCall.setProgram(path.getPath(), pp.getAsParms());
                if (this.programCall.run()) {
                    pp.returnAsParms();
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                this.programCall = null;
                e.printStackTrace();
                if (i != 0) {
                    throw new RuntimeException("Impossibile elaborare il programma a sistema");
                }
                System.out.println("Rilevato errore durante lancio programma a sistema viene ritentata una seconda elaborazione");
                ++i;
            }
        }
        return false;
    }

    private boolean commandCall(ProgramDefinition pgmDef) {
        Query q = pgmDef.getEm().createNativeQuery("CALL SAGAGEN.XADDLI");
        q.executeUpdate();
        q = pgmDef.getEm().createNativeQuery("CALL INTVIEW2.INTVIEWENV");
        q.executeUpdate();
        String cmd = null;
        if (this.properties.getCommonSchema() != null && !this.properties.getCommonSchema().isEmpty()) {
            cmd = "CHGCURLIB " + this.properties.getCommonSchema();
            this.executeCmd(cmd, pgmDef.getEm());
            cmd = "ADDLIBLE " + this.properties.getDftSchema();
            this.executeCmd(cmd, pgmDef.getEm());
        } else {
            cmd = "CHGCURLIB " + this.properties.getDftSchema();
            this.executeCmd(cmd, pgmDef.getEm());
        }
        String outq = this.properties.getPrinter();
        if (outq != null) {
            cmd = "CHGJOB OUTQ(" + outq + ")";
            this.executeCmd(cmd, pgmDef.getEm());
        }
        this.executeCmd(pgmDef.getCommand(), pgmDef.getEm());
        return true;
    }

    private void executeCmd(String cmd, EntityManager em) {
        Query q = em.createNativeQuery("CALL QSYS.QCMDEXC('" + cmd + "', " + StringUtils.leftPad((String)Integer.toString(cmd.length()), (int)10, (char)'0') + ".00000)");
        q.executeUpdate();
    }

    private ProgramCall init() throws PropertyVetoException, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        AS400 as400 = new AS400(this.properties.getHost(), this.properties.getUser(), this.properties.getPassword());
        ProgramCall pc = new ProgramCall(as400);
        QSYSObjectPathName path = new QSYSObjectPathName("SAGAGEN", "XADDLI", "PGM");
        pc.setProgram(path.getPath());
        if (!pc.run()) {
            return null;
        }
        path = new QSYSObjectPathName("INTVIEW2", "INTVIEWENV", "PGM");
        pc.setProgram(path.getPath());
        pc.run();
        CommandCall cc = new CommandCall(as400);
        if (this.properties.getCommonSchema() != null && !this.properties.getCommonSchema().isEmpty()) {
            cc.run("CHGCURLIB " + this.properties.getCommonSchema());
            cc.run("ADDLIBLE " + this.properties.getDftSchema());
        } else {
            cc.run("CHGCURLIB " + this.properties.getDftSchema());
        }
        String outq = this.properties.getPrinter();
        if (outq != null) {
            cc.run("CHGJOB OUTQ(" + outq + ")");
        }
        return pc;
    }

    class PgmParms {
        private ProgramParameter[] parms;
        private AS400DataType[] types;
        private final Object[] iparams;

        PgmParms(Object[] list) {
            this.iparams = list;
            this.innerInit();
        }

        public void returnAsParms() throws PropertyVetoException {
            int i = 0;
            while (i < this.parms.length) {
                this.iparams[i] = this.types[i].toObject(this.parms[i].getOutputData());
                ++i;
            }
        }

        public ProgramParameter[] getAsParms() throws PropertyVetoException {
            int i = 0;
            while (i < this.parms.length) {
                this.parms[i].setInputData(this.types[i].toBytes(this.iparams[i]));
                ++i;
            }
            return this.parms;
        }

        private void innerInit() {
            this.parms = new ProgramParameter[this.iparams.length];
            this.types = new AS400DataType[this.iparams.length];
            int i = 0;
            while (i < this.parms.length) {
                Object o = this.iparams[i];
                if (o instanceof String) {
                    String s = (String)o;
                    this.parms[i] = new ProgramParameter(s.length());
                    this.types[i] = new AS400Text(s.length());
                } else if (o instanceof BigDecimal) {
                    BigDecimal b = (BigDecimal)o;
                    this.parms[i] = new ProgramParameter(16);
                    this.types[i] = new AS400PackedDecimal(30, b.scale());
                } else {
                    throw new RuntimeException(MessageFormat.format("Tipo di parametro passato {0} non previsto dal programma", o));
                }
                ++i;
            }
        }
    }
}

