/*
 * Decompiled with CFR 0.152.
 */
package com.vela.balance.inner;

import com.vela.balance.inner.SecurityManager;
import java.util.UUID;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SecurityDialog
extends TitleAreaDialog {
    private Text tDigest;
    private String uuid = UUID.randomUUID().toString();
    private String digest = "";
    private final SecurityManager secManager;

    public SecurityDialog(Shell parentShell, SecurityManager secManager) {
        super(parentShell);
        this.secManager = secManager;
    }

    public void create() {
        super.create();
        this.setTitle("Inserimento chiave di sblocco");
        this.setMessage("Contattare l'assistenza per ottenere la chiave di sblocco", 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.marginRight = 5;
        layout.marginLeft = 10;
        container.setLayout((Layout)layout);
        Label lUuid = new Label(container, 0);
        lUuid.setText("Codice sblocco:");
        Text tUuid = new Text(container, 2056);
        tUuid.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        tUuid.setText(this.uuid);
        Label lblPassword = new Label(container, 0);
        GridData gd_lblNewLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel.horizontalIndent = 1;
        lblPassword.setLayoutData((Object)gd_lblNewLabel);
        lblPassword.setText("Chiave:");
        this.tDigest = new Text(container, 2048);
        this.tDigest.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.tDigest.setText(this.digest);
        this.tDigest.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text textWidget = (Text)e.getSource();
                SecurityDialog.this.digest = textWidget.getText();
            }
        });
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Conferma", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    protected void okPressed() {
        this.digest = this.tDigest.getText();
        if (!this.secManager.checkAuth(this.uuid, this.digest)) {
            this.setMessage("Chiave di sblocco errata", 3);
            this.tDigest.setFocus();
        }
        super.okPressed();
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getDigest() {
        return this.digest;
    }
}

