/*
 * Decompiled with CFR 0.152.
 */
package com.vela.balance.ui;

import com.vela.balance.BalanceService;
import com.vela.balance.data.BalanceRow;
import com.vela.balance.data.BalanceSheet;
import com.vela.balance.inner.SecurityDialog;
import com.vela.balance.inner.SecurityManager;
import com.vela.balance.security.SecurityChecker;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessAdditions;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;

public class LifeCycleHandler {
    @Inject
    @Optional
    SecurityChecker securityChecker;

    @PostContextCreate
    void postContextCreate(IApplicationContext appContext, Display display, @Preference(nodePath="com.vela.banlance.sec") IEclipsePreferences prefs) {
        if (!this.securityChecker.appEnabled()) {
            Shell shell = new Shell(1264);
            MessageDialog.openError((Shell)shell, (String)"Licenza scaduta", (String)this.securityChecker.getErrMessage());
            System.exit(-1);
        }
        if (this.securityChecker.requestUnlockKey()) {
            try {
                SecurityManager secMgr = new SecurityManager();
                String uuid = prefs.get("uuid", "");
                String digest = prefs.get("digest", "");
                if (!secMgr.checkAuth(uuid, digest)) {
                    appContext.applicationRunning();
                    Shell shell = new Shell(1264);
                    SecurityDialog dialog = new SecurityDialog(shell, secMgr);
                    if (dialog.open() != 0 || !secMgr.checkAuth(dialog.getUuid(), dialog.getDigest())) {
                        System.exit(-1);
                    }
                    prefs.put("uuid", dialog.getUuid());
                    prefs.put("digest", dialog.getDigest());
                    prefs.flush();
                }
            }
            catch (NoSuchAlgorithmException | BackingStoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @ProcessAdditions
    void processAdditions(EPartService partService, MApplication application, EModelService modelService, BalanceService balanceSrv) {
        balanceSrv.getBalanceTemplate().getSheets();
        ArrayList<BalanceSheet> lista = new ArrayList<BalanceSheet>();
        for (BalanceSheet bs : balanceSrv.getBalanceTemplate().getSheets()) {
            MPart part = MBasicFactory.INSTANCE.createPart();
            part.setLabel(bs.getTitle());
            part.setContributionURI("bundleclass://com.vela.balance.ui/com.vela.balance.ui.parts.BalancePart");
            part.setCloseable(false);
            part.getTransientData().put("model", bs);
            List stacks = modelService.findElements((MUIElement)application, null, MPartStack.class, null);
            ((MPartStack)stacks.get(0)).getChildren().add(part);
            lista.add(bs);
        }
        ArrayList<BalanceRow> listabr = new ArrayList<BalanceRow>();
        for (BalanceSheet element : lista) {
            for (BalanceRow row : element.getRows()) {
                listabr.add(row);
            }
        }
        MPart partass = MBasicFactory.INSTANCE.createPart();
        partass.setLabel("Associa");
        partass.setContributionURI("bundleclass://com.vela.balance.ui/com.vela.balance.ui.parts.AssignPart");
        partass.setCloseable(false);
        partass.getTransientData().put("modelassign", listabr);
        List stacks = modelService.findElements((MUIElement)application, null, MPartStack.class, null);
        ((MPartStack)stacks.get(0)).getChildren().add(partass);
    }
}

