/*
 * Decompiled with CFR 0.152.
 */
package com.vela.balance.ui.dialogs;

import com.vela.balance.BalanceService;
import java.util.Calendar;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BalanceDialog
extends TitleAreaDialog {
    private DateTime toDate;
    private DateTime fromEco;
    private Button from;
    private Button extra;
    private final BalanceService balanceSrv;

    public BalanceDialog(Shell parentShell, BalanceService balanceSrv) {
        super(parentShell);
        this.balanceSrv = balanceSrv;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite c = new Composite(container, 0);
        c.setLayoutData((Object)new GridData(4, 4, true, false));
        c.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(c, 0);
        l.setText("Data di calcolo dei dati contabili");
        this.toDate = new DateTime(c, 65572);
        l = new Label(c, 0);
        this.from = new Button(c, 32);
        this.from.setText("Reperire i saldi dei conti economici da data");
        l = new Label(c, 0);
        l.setText("Data di inizio calcolo coonti economici");
        this.fromEco = new DateTime(c, 65572);
        this.fromEco.setEnabled(false);
        l = new Label(c, 0);
        this.extra = new Button(c, 32);
        this.extra.setText("Includere i movimenti provvisori");
        this.from.addListener(13, ls -> this.fromEco.setEnabled(this.from.getSelection()));
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Reperimento saldi dei conti da sistema");
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        Calendar c = Calendar.getInstance();
        c.set(this.toDate.getYear(), this.toDate.getMonth(), this.toDate.getDay());
        Calendar c1 = null;
        if (this.from.getSelection()) {
            c1 = Calendar.getInstance();
            c1.set(this.fromEco.getYear(), this.fromEco.getMonth(), this.fromEco.getDay());
        }
        String error = null;
        error = this.balanceSrv.computeBalance(c, c1, this.extra.getSelection());
        if (error != null) {
            this.setErrorMessage(error);
            return;
        }
        super.okPressed();
    }

    protected boolean canHandleShellCloseEvent() {
        return false;
    }
}

