/*
 * Decompiled with CFR 0.152.
 */
package com.vela.balance.ui.handlers;

import com.vela.balance.BalanceService;
import java.nio.file.Paths;
import java.util.Arrays;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SaveHandler {
    @CanExecute
    public boolean canExecute(EPartService partService) {
        return true;
    }

    @Execute
    public void execute(Shell shell, EPartService partService, BalanceService balanceSrv) {
        if (Arrays.equals(balanceSrv.getBalanceTemplate().getSectors(), new boolean[balanceSrv.getBalanceTemplate().getSectors().length])) {
            MessageDialog.openWarning((Shell)shell, (String)"Attenzione", (String)"Indicare il tipo di attivit\u00e0 prima di continuare");
            return;
        }
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setFilterNames(new String[]{"File di excel (*.xlsx)"});
        fileDialog.setFilterExtensions(new String[]{"*.xlsx"});
        fileDialog.setText("Seleziona il file da salvare");
        String file = fileDialog.open();
        if (file == null) {
            return;
        }
        partService.saveAll(false);
        try {
            balanceSrv.storeBalance(Paths.get(file, new String[0]));
            Program.launch((String)file);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)shell, (String)"Errore", (String)(e.getMessage() != null ? e.getMessage() : e.toString()));
            e.printStackTrace();
        }
    }
}

