/*
 * Decompiled with CFR 0.152.
 */
package com.vela.balance.ui.handlers;

import com.vela.balance.BalanceService;
import com.vela.balance.data.BalanceSheet;
import com.vela.balance.ui.dialogs.BalanceDialog;
import com.vela.videosupport.APart;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SyncHandler
extends APart {
    @CanExecute
    public boolean canExecute(EPartService partService) {
        return true;
    }

    @Execute
    public void execute(Shell shell, EPartService partService, BalanceService balanceSrv) {
        try {
            BalanceDialog balDialog = new BalanceDialog(shell, balanceSrv);
            if (balDialog.open() != 0) {
                return;
            }
            try {
                this.setBusy();
                for (BalanceSheet bs : balanceSrv.getBalanceTemplate().getSheets()) {
                    balanceSrv.syncBalance(bs);
                }
            }
            catch (Exception e) {
                this.showErrMsg(e, shell);
            }
        }
        finally {
            this.setIdle();
            MessageDialog.openInformation((Shell)shell, (String)"Sincronizzazione completata", (String)"Sincronizzazione dati completata");
        }
    }
}

