/*
 * Decompiled with CFR 0.152.
 */
package com.vela.balance.ui.handlers;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class UpdateHandler {
    private static final String REPOSITORY_LOC = System.getProperty("UpdateHandler.Repo", "http://www.gruppovela.it/repos/velabilancio");

    @Execute
    public void execute(final IProvisioningAgent agent, final Shell shell, final UISynchronize sync, final IWorkbench workbench) {
        Job updateJob = new Job("Aggiornamento"){

            protected IStatus run(IProgressMonitor monitor) {
                return UpdateHandler.this.checkForUpdates(agent, shell, sync, workbench, monitor);
            }
        };
        updateJob.schedule();
    }

    private IStatus checkForUpdates(IProvisioningAgent agent, Shell shell, UISynchronize sync, IWorkbench workbench, IProgressMonitor monitor) {
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        this.configureUpdate(operation);
        IStatus status = operation.resolveModal(monitor);
        if (status.getCode() == 10000) {
            this.showMessage(shell, sync);
            return Status.CANCEL_STATUS;
        }
        ProvisioningJob provisioningJob = operation.getProvisioningJob(monitor);
        if (provisioningJob == null) {
            System.err.println("Trying to update from the Eclipse IDE? This won't work!");
            return Status.CANCEL_STATUS;
        }
        this.configureProvisioningJob(provisioningJob, shell, sync, workbench);
        provisioningJob.schedule();
        return Status.OK_STATUS;
    }

    private void configureProvisioningJob(ProvisioningJob provisioningJob, final Shell shell, final UISynchronize sync, final IWorkbench workbench) {
        provisioningJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    sync.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            boolean restart = MessageDialog.openQuestion((Shell)shell, (String)"Aggiornamenti installati, riavviare?", (String)"Gli aggiornamenti sono stati installati, riavviare per renderli operativi?");
                            if (restart) {
                                workbench.restart();
                            }
                        }
                    });
                }
                super.done(event);
            }
        });
    }

    private void showMessage(final Shell parent, UISynchronize sync) {
        sync.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)parent, (String)"Versione aggiornata", (String)"La versione del software \u00e8 aggiornata.");
            }
        });
    }

    private UpdateOperation configureUpdate(UpdateOperation operation) {
        URI uri = null;
        try {
            uri = new URI(REPOSITORY_LOC);
        }
        catch (URISyntaxException e) {
            System.err.println(e.getMessage());
            return null;
        }
        operation.getProvisioningContext().setArtifactRepositories(new URI[]{uri});
        operation.getProvisioningContext().setMetadataRepositories(new URI[]{uri});
        return operation;
    }
}

