/*
 * Decompiled with CFR 0.152.
 */
package com.vela.balance.ui.handlers;

import com.vela.balance.BalanceService;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class WebHandler {
    @CanExecute
    public boolean canExecute(EPartService partService) {
        return true;
    }

    @Execute
    public void execute(Shell shell, EPartService partService, BalanceService balanceSrv) {
        partService.saveAll(false);
        try {
            File ffull = balanceSrv.esportaWeb();
            if (ffull == null) {
                throw new RuntimeException("Errore in creazione file!");
            }
            FileDialog fileDialog = new FileDialog(shell, 8192);
            fileDialog.setFilterNames(new String[]{"File di esportazione Web (*.json)"});
            fileDialog.setFilterExtensions(new String[]{"*.json"});
            fileDialog.setText("Seleziona dove salvare il file");
            String file = fileDialog.open();
            if (file == null) {
                return;
            }
            try {
                Files.copy(ffull.toPath(), Paths.get(file, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)shell, (String)"Errore", (String)(e.getMessage() != null ? e.getMessage() : e.toString()));
                e.printStackTrace();
            }
            MessageDialog.openInformation((Shell)shell, (String)"Esportazione file per versione Web", (String)"Effettuata con successo!");
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)shell, (String)"Errore", (String)(e.getMessage() != null ? e.getMessage() : e.toString()));
        }
    }
}

