/*
 * Decompiled with CFR 0.152.
 */
package com.vela.balance.ui.parts;

import com.vela.balance.BalanceService;
import com.vela.balance.data.AssEntity;
import com.vela.balance.data.BalanceRow;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class AssignPart {
    private static final NumberFormat AMOUNT_FORMAT = new DecimalFormat("#,###");
    private TableViewer tableViewer;
    private TableViewer tableViewer2;
    @Inject
    private MDirtyable dirty;
    @Inject
    MPart part;
    @Inject
    BalanceService balanceService;
    private SashForm sashForm;
    private Composite tableComposite;
    private Composite tableComposite2;
    private TableColumnLayout tableColumnLayout;
    private TableColumnLayout tableColumnLayout2;
    private Composite composite;
    private Button btnNewButton2;
    private TableViewerColumn columnKA;
    private TableViewerColumn columnKD;
    private TableViewerColumn columncod;
    private TableViewerColumn columnName;
    private TableViewerColumn columnSaldo;
    private Button btnDare;
    private Button btnAvere;
    private Button btnTutto;
    private Button btnSalva;
    private Label lblOpzioneVisualizzazione;
    private Combo combo;
    private Label label;
    private Label label_1;
    private List<? extends AssEntity> ass;
    private List<? extends AssEntity> ass2;
    private List<? extends AssEntity> assort;
    private Listener sortListener;
    private Button btnResettaSelezionato;

    @PostConstruct
    public void createComposite(final Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        try {
            this.ass = this.balanceService.getAssEntities();
            this.ass2 = this.ass.stream().filter(p -> p.getKeyA().trim().isEmpty() && p.getKeyD().trim().isEmpty()).collect(Collectors.toList());
            this.assort = this.ass;
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)parent.getShell(), (String)"Attenzione Errore", (String)(e.getMessage() + "\n" + "\n" + "\n" + "Riavviare l'applicativo controllando parametri connessione"));
        }
        List lista = (List)this.part.getTransientData().get("modelassign");
        this.createSash(parent);
        this.tableViewer = this.buildTableViewer1(parent);
        this.tableViewer2 = this.buildTableViewer2(parent);
        this.tableViewer.setInput((Object)lista);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        PropertyChangeListener pcl = l -> this.tableViewer.update(l.getSource(), null);
        for (BalanceRow balanceRow : lista) {
            balanceRow.addPropertyChangeListener(pcl);
        }
        for (AssEntity assEntity : this.ass) {
            if (assEntity.getType() != 1) continue;
            if (!assEntity.getKeyD().equals("")) break;
            this.associaCliForni();
            break;
        }
        this.tableViewer2.setInput(this.ass);
        this.tableViewer2.getTable().setLayoutData((Object)new GridData(1808));
        this.btnNewButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection3 = (IStructuredSelection)AssignPart.this.tableViewer.getSelection();
                BalanceRow rowData = (BalanceRow)selection3.getFirstElement();
                int[] indi = AssignPart.this.tableViewer2.getTable().getSelectionIndices();
                if (rowData != null && indi.length != 0) {
                    if (!rowData.isTitle()) {
                        if (rowData.isTotal()) {
                            MessageDialog.openWarning((Shell)parent.getShell(), (String)"Attenzione", (String)"E' stato selezionata una voce di totale");
                        } else if (AssignPart.this.combo.getSelectionIndex() == 0) {
                            int[] nArray = indi;
                            int n = indi.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int element = nArray[n2];
                                AssEntity rowData3 = AssignPart.this.ass.get(element);
                                int g = 0;
                                while (g < AssignPart.this.ass2.size()) {
                                    if (rowData3.getCode() == AssignPart.this.ass2.get(g).getCode()) {
                                        AssignPart.this.ass2.remove(g);
                                        break;
                                    }
                                    ++g;
                                }
                                if (AssignPart.this.btnTutto.getSelection()) {
                                    rowData3.setKeyD(rowData.getCode());
                                    rowData3.setKeyA(rowData.getCode());
                                } else if (AssignPart.this.btnDare.getSelection()) {
                                    rowData3.setKeyD(rowData.getCode());
                                } else if (AssignPart.this.btnAvere.getSelection()) {
                                    rowData3.setKeyA(rowData.getCode());
                                }
                                ++n2;
                            }
                            AssignPart.this.tableViewer2.refresh();
                        } else {
                            int[] nArray = indi;
                            int n = indi.length;
                            int n3 = 0;
                            while (n3 < n) {
                                int element = nArray[n3];
                                AssEntity rowData4 = AssignPart.this.ass2.get(element);
                                AssEntity rowData5 = null;
                                for (AssEntity assEntity : AssignPart.this.ass) {
                                    if (rowData4.getCode() != assEntity.getCode()) continue;
                                    rowData5 = assEntity;
                                    break;
                                }
                                if (AssignPart.this.btnTutto.getSelection()) {
                                    rowData5.setKeyD(rowData.getCode());
                                    rowData5.setKeyA(rowData.getCode());
                                    rowData4.setKeyD(rowData.getCode());
                                    rowData4.setKeyA(rowData.getCode());
                                } else if (AssignPart.this.btnDare.getSelection()) {
                                    rowData5.setKeyD(rowData.getCode());
                                    rowData4.setKeyD(rowData.getCode());
                                } else if (AssignPart.this.btnAvere.getSelection()) {
                                    rowData5.setKeyA(rowData.getCode());
                                    rowData4.setKeyA(rowData.getCode());
                                }
                                AssignPart.this.ass2.remove(element);
                                ++n3;
                            }
                            AssignPart.this.tableViewer2.refresh();
                        }
                    } else {
                        MessageDialog.openWarning((Shell)parent.getShell(), (String)"Attenzione", (String)"E' stato selezionata una voce di titolo");
                    }
                } else {
                    MessageDialog.openInformation((Shell)parent.getShell(), (String)"Info", (String)"Non \u00e8 stata selezionata una riga per ciascuna tabella");
                }
            }
        });
        this.btnSalva.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AssignPart.this.balanceService.storeAssEntity(AssignPart.this.ass);
                AssignPart.this.ass2 = AssignPart.this.ass.stream().filter(p -> p.getKeyA().trim().isEmpty() && p.getKeyD().trim().isEmpty()).collect(Collectors.toList());
                MessageDialog.openInformation((Shell)parent.getShell(), (String)"Info", (String)"Salvataggio completato");
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (AssignPart.this.combo.getSelectionIndex() == 0) {
                    AssignPart.this.assort = AssignPart.this.ass;
                    AssignPart.this.tableViewer2.setInput(AssignPart.this.ass);
                    AssignPart.this.tableViewer2.refresh();
                } else if (AssignPart.this.combo.getSelectionIndex() == 1) {
                    AssignPart.this.assort = AssignPart.this.ass2;
                    AssignPart.this.tableViewer2.setInput(AssignPart.this.ass2);
                    AssignPart.this.tableViewer2.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFDF;
                if ((event.detail & 2) == 0) {
                    return;
                }
                int clientWidth = AssignPart.this.tableViewer.getTable().getClientArea().width;
                GC gc = event.gc;
                Color oldForeground = gc.getForeground();
                Color oldBackground = gc.getBackground();
                gc.setForeground(parent.getDisplay().getSystemColor(13));
                gc.setBackground(parent.getDisplay().getSystemColor(13));
                gc.fillGradientRectangle(0, event.y, clientWidth, event.height, false);
                gc.setForeground(oldForeground);
                gc.setBackground(oldBackground);
                event.detail &= 0xFFFFFFFD;
            }
        };
        this.tableViewer.getTable().addListener(40, listener);
        this.tableViewer2.getTable().addListener(40, listener);
        this.sortListener = new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                if (column == AssignPart.this.columncod.getColumn()) {
                    if (AssignPart.this.assort.size() > 0) {
                        Collections.sort(AssignPart.this.assort, new Comparator<AssEntity>(){

                            @Override
                            public int compare(AssEntity object1, AssEntity object2) {
                                return String.valueOf(object1.getCode()).compareTo(String.valueOf(object2.getCode()));
                            }
                        });
                    }
                } else if (column == AssignPart.this.columnName.getColumn()) {
                    if (AssignPart.this.assort.size() > 0) {
                        Collections.sort(AssignPart.this.assort, new Comparator<AssEntity>(){

                            @Override
                            public int compare(AssEntity object1, AssEntity object2) {
                                return String.valueOf(object1.getCompanyName()).compareTo(String.valueOf(object2.getCompanyName()));
                            }
                        });
                    }
                } else if (column == AssignPart.this.columnSaldo.getColumn()) {
                    if (AssignPart.this.assort.size() > 0) {
                        Collections.sort(AssignPart.this.assort, new Comparator<AssEntity>(){

                            @Override
                            public int compare(AssEntity object1, AssEntity object2) {
                                if (object1.getBalance() == null && object2.getBalance() == null) {
                                    return 0;
                                }
                                if (object1.getBalance() == null) {
                                    return 1;
                                }
                                if (object2.getBalance() == null) {
                                    return -1;
                                }
                                return object1.getBalance().getSaldo().compareTo(object2.getBalance().getSaldo());
                            }
                        });
                    }
                } else if (column == AssignPart.this.columnKD.getColumn()) {
                    if (AssignPart.this.assort.size() > 0) {
                        Collections.sort(AssignPart.this.assort, new Comparator<AssEntity>(){

                            @Override
                            public int compare(AssEntity object1, AssEntity object2) {
                                return String.valueOf(object1.getKeyD()).compareTo(String.valueOf(object2.getKeyD()));
                            }
                        });
                    }
                } else if (column == AssignPart.this.columnKA.getColumn() && AssignPart.this.assort.size() > 0) {
                    Collections.sort(AssignPart.this.assort, new Comparator<AssEntity>(){

                        @Override
                        public int compare(AssEntity object1, AssEntity object2) {
                            return String.valueOf(object1.getKeyA()).compareTo(String.valueOf(object2.getKeyA()));
                        }
                    });
                }
                AssignPart.this.tableViewer2.getTable().setSortColumn(column);
                AssignPart.this.tableViewer2.refresh();
            }
        };
        this.columncod.getColumn().addListener(13, this.sortListener);
        this.columnName.getColumn().addListener(13, this.sortListener);
        this.columnSaldo.getColumn().addListener(13, this.sortListener);
        this.columnKD.getColumn().addListener(13, this.sortListener);
        this.columnKA.getColumn().addListener(13, this.sortListener);
        this.btnResettaSelezionato.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indi;
                int[] nArray = indi = AssignPart.this.tableViewer2.getTable().getSelectionIndices();
                int n = indi.length;
                int n2 = 0;
                while (n2 < n) {
                    int element = nArray[n2];
                    AssEntity rowData5 = AssignPart.this.ass.get(element);
                    rowData5.setKeyD("");
                    rowData5.setKeyA("");
                    ++n2;
                }
                AssignPart.this.tableViewer2.refresh();
            }
        });
    }

    private void createSash(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout gl_composite = new GridLayout(10, false);
        this.composite.setLayout((Layout)gl_composite);
        this.composite.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.lblOpzioneVisualizzazione = new Label(this.composite, 0);
        this.lblOpzioneVisualizzazione.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblOpzioneVisualizzazione.setText("Opzione Visualizzazione:");
        this.combo = new Combo(this.composite, 0);
        this.combo.add("Tutti");
        this.combo.add("Non Associati");
        this.combo.select(0);
        this.label_1 = new Label(this.composite, 514);
        GridData layoutData = new GridData();
        layoutData.heightHint = 35;
        this.label_1.setLayoutData((Object)layoutData);
        this.btnSalva = new Button(this.composite, 0);
        this.btnSalva.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnSalva.setText("Salva");
        this.label = new Label(this.composite, 514);
        layoutData = new GridData();
        layoutData.heightHint = 35;
        this.label.setLayoutData((Object)layoutData);
        this.btnTutto = new Button(this.composite, 16);
        this.btnTutto.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnTutto.setText("Tutti");
        this.btnTutto.setSelection(true);
        this.btnDare = new Button(this.composite, 16);
        this.btnDare.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnDare.setText("Dare");
        this.btnAvere = new Button(this.composite, 16);
        this.btnAvere.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnAvere.setText("Avere");
        this.btnNewButton2 = new Button(this.composite, 0);
        this.btnNewButton2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNewButton2.setText("Associa");
        this.btnResettaSelezionato = new Button(this.composite, 0);
        this.btnResettaSelezionato.setText("Resetta selezionato");
        this.sashForm = new SashForm(parent, 0);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.tableComposite = new Composite((Composite)this.sashForm, 0);
        this.tableComposite.setLayoutData((Object)new GridData(1808));
        this.tableColumnLayout = new TableColumnLayout();
        this.tableComposite.setLayout((Layout)this.tableColumnLayout);
        this.tableComposite2 = new Composite((Composite)this.sashForm, 0);
        this.tableComposite2.setLayoutData((Object)new GridData(1808));
        this.tableColumnLayout2 = new TableColumnLayout();
        this.tableComposite2.setLayout((Layout)this.tableColumnLayout2);
        this.sashForm.setWeights(new int[]{1, 1});
    }

    private TableViewer buildTableViewer1(Composite parent) {
        TableViewer viewer = new TableViewer(this.tableComposite, 68356);
        TableViewerEditor.create((TableViewer)viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)viewer), (int)26);
        this.buildTableColumns(viewer, this.tableColumnLayout);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        return viewer;
    }

    private TableViewer buildTableViewer2(Composite parent) {
        TableViewer viewer = new TableViewer(this.tableComposite2, 68354);
        TableViewerEditor.create((TableViewer)viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)viewer), (int)26);
        this.buildTableColumns2(viewer, this.tableColumnLayout2);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        return viewer;
    }

    private void buildTableColumns(TableViewer viewer, TableColumnLayout tableColumnLayout) {
        TableViewerColumn column = new TableViewerColumn(viewer, 0);
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, true));
        column.getColumn().setText("CODE");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((BalanceRow)element).getCode();
            }

            public Color getBackground(Object element) {
                BalanceRow br = (BalanceRow)element;
                if (br.isTitle()) {
                    if (br.getCode().equals("SP3_")) {
                        return Display.getDefault().getSystemColor(5);
                    }
                    if (br.getCode().equals("E_")) {
                        return Display.getDefault().getSystemColor(3);
                    }
                    return Display.getDefault().getSystemColor(15);
                }
                return super.getBackground(element);
            }
        });
        column = new TableViewerColumn(viewer, 0);
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(400, true));
        column.getColumn().setText("Voce");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((BalanceRow)element).getDescription();
            }

            public Color getBackground(Object element) {
                BalanceRow br = (BalanceRow)element;
                if (br.isTitle()) {
                    if (br.getCode().equals("SP3_")) {
                        return Display.getDefault().getSystemColor(5);
                    }
                    if (br.getCode().equals("E_")) {
                        return Display.getDefault().getSystemColor(3);
                    }
                    return Display.getDefault().getSystemColor(15);
                }
                return super.getBackground(element);
            }
        });
    }

    private void buildTableColumns2(TableViewer viewer, TableColumnLayout tableColumnLayout) {
        this.columncod = new TableViewerColumn(viewer, 0);
        tableColumnLayout.setColumnData((Widget)this.columncod.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, true));
        this.columncod.getColumn().setText("Cod.Conto");
        this.columncod.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                long code = ((AssEntity)element).getCode();
                return String.valueOf(code);
            }
        });
        this.columnName = new TableViewerColumn(viewer, 0);
        tableColumnLayout.setColumnData((Widget)this.columnName.getColumn(), (ColumnLayoutData)new ColumnWeightData(400, true));
        this.columnName.getColumn().setText("CompanyName");
        this.columnName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((AssEntity)element).getCompanyName();
            }
        });
        this.columnSaldo = new TableViewerColumn(viewer, 131072);
        tableColumnLayout.setColumnData((Widget)this.columnSaldo.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, true));
        this.columnSaldo.getColumn().setText("Saldo");
        this.columnSaldo.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((AssEntity)element).getBalance() == null ? "" : AMOUNT_FORMAT.format(((AssEntity)element).getBalance().getSaldo());
            }
        });
        this.columnKD = new TableViewerColumn(viewer, 131072);
        tableColumnLayout.setColumnData((Widget)this.columnKD.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, true));
        this.columnKD.getColumn().setText("Chiave Dare");
        this.columnKD.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((AssEntity)element).getKeyD();
            }
        });
        this.columnKA = new TableViewerColumn(viewer, 131072);
        tableColumnLayout.setColumnData((Widget)this.columnKA.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, true));
        this.columnKA.getColumn().setText("Chiave Avere");
        this.columnKA.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((AssEntity)element).getKeyA();
            }
        });
    }

    private void associaCliForni() {
        for (AssEntity assEntity : this.ass) {
            if (assEntity.getType() == 1) {
                assEntity.setKeyD("PAC21_e");
                assEntity.setKeyA("PAC21_e");
            }
            if (assEntity.getType() != 2) continue;
            assEntity.setKeyD("PPD7_s");
            assEntity.setKeyA("PPD7_s");
        }
    }

    @Focus
    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    @Persist
    public void save() {
        this.dirty.setDirty(false);
    }

    class AmountEditingSupport
    extends EditingSupport {
        private final CellEditor editor;
        private final boolean prv;

        public AmountEditingSupport(TableViewer viewer, boolean prv) {
            super((ColumnViewer)viewer);
            this.prv = prv;
            this.editor = new TextCellEditor((Composite)viewer.getTable());
            this.editor.setValidator(v -> {
                try {
                    AMOUNT_FORMAT.parse(v.toString());
                }
                catch (Exception e) {
                    return "Il numero inserito non \u00e8 valido";
                }
                return null;
            });
        }

        private <E> E translate(Object o) {
            return (E)o;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return ((BalanceRow)this.translate(element)).isData();
        }

        protected Object getValue(Object element) {
            return AMOUNT_FORMAT.format(this.prv ? ((BalanceRow)this.translate(element)).getPrvBalance() : ((BalanceRow)this.translate(element)).getCurBalance());
        }

        protected void setValue(Object element, Object value) {
            try {
                BigDecimal val = new BigDecimal(AMOUNT_FORMAT.parse(value.toString()).toString());
                if (this.prv) {
                    ((BalanceRow)this.translate(element)).setPrvBalance(val);
                } else {
                    ((BalanceRow)this.translate(element)).setCurBalance(val);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }
}

