/*
 * Decompiled with CFR 0.152.
 */
package com.vela.balance.ui.parts;

import com.vela.balance.data.BalanceRow;
import com.vela.balance.data.BalanceSheet;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class BalancePart {
    private static final NumberFormat AMOUNT_FORMAT = new DecimalFormat("#,###");
    private TableViewer tableViewer;
    private BalanceSheet bs;
    @Inject
    private MDirtyable dirty;
    @Inject
    MPart part;

    @PostConstruct
    public void createComposite(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.bs = (BalanceSheet)this.part.getTransientData().get("model");
        this.tableViewer = this.buildTableViewer(parent);
        this.tableViewer.setInput((Object)this.bs.getRows());
        this.tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        PropertyChangeListener pcl = l -> this.tableViewer.update(l.getSource(), null);
        for (BalanceRow br : this.bs.getRows()) {
            br.addPropertyChangeListener(pcl);
        }
    }

    private TableViewer buildTableViewer(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayoutData((Object)new GridData(1808));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        TableViewer viewer = new TableViewer(tableComposite, 68356);
        TableViewerEditor.create((TableViewer)viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)viewer), (int)26);
        this.buildTableColumns(viewer, tableColumnLayout);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        return viewer;
    }

    private void buildTableColumns(TableViewer viewer, TableColumnLayout tableColumnLayout) {
        TableViewerColumn column = new TableViewerColumn(viewer, 0);
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(400, true));
        column.getColumn().setText("Voce");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((BalanceRow)element).getDescription();
            }

            public Color getBackground(Object element) {
                BalanceRow br = (BalanceRow)element;
                if (br.isTitle()) {
                    return Display.getDefault().getSystemColor(15);
                }
                return super.getBackground(element);
            }
        });
        column = new TableViewerColumn(viewer, 131072);
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, true));
        column.getColumn().setText("Anno Precedente");
        column.setEditingSupport((EditingSupport)new AmountEditingSupport(viewer, true));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                BalanceRow br = (BalanceRow)element;
                return br.isTitle() ? "" : AMOUNT_FORMAT.format(br.getPrvBalance());
            }

            public Color getBackground(Object element) {
                BalanceRow br = (BalanceRow)element;
                if (br.isTotal()) {
                    return Display.getDefault().getSystemColor(15);
                }
                return super.getBackground(element);
            }
        });
        column = new TableViewerColumn(viewer, 131072);
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, true));
        column.getColumn().setText("Anno in Corso");
        column.setEditingSupport((EditingSupport)new AmountEditingSupport(viewer, false));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                BalanceRow br = (BalanceRow)element;
                return br.isTitle() ? "" : AMOUNT_FORMAT.format(br.getCurBalance());
            }

            public Color getBackground(Object element) {
                BalanceRow br = (BalanceRow)element;
                if (br.isTotal()) {
                    return Display.getDefault().getSystemColor(15);
                }
                return super.getBackground(element);
            }
        });
    }

    @Focus
    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    @Persist
    public void save() {
        this.dirty.setDirty(false);
    }

    class AmountEditingSupport
    extends EditingSupport {
        private final CellEditor editor;
        private final boolean prv;

        public AmountEditingSupport(TableViewer viewer, boolean prv) {
            super((ColumnViewer)viewer);
            this.prv = prv;
            this.editor = new TextCellEditor((Composite)viewer.getTable());
            this.editor.setValidator(v -> {
                try {
                    AMOUNT_FORMAT.parse(v.toString());
                }
                catch (Exception e) {
                    return "Il numero inserito non \u00e8 valido";
                }
                return null;
            });
        }

        private <E> E translate(Object o) {
            return (E)o;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return ((BalanceRow)this.translate(element)).isData();
        }

        protected Object getValue(Object element) {
            return AMOUNT_FORMAT.format(this.prv ? ((BalanceRow)this.translate(element)).getPrvBalance() : ((BalanceRow)this.translate(element)).getCurBalance());
        }

        protected void setValue(Object element, Object value) {
            try {
                BigDecimal val = new BigDecimal(AMOUNT_FORMAT.parse(value.toString()).toString());
                if (this.prv) {
                    ((BalanceRow)this.translate(element)).setPrvBalance(val);
                } else {
                    ((BalanceRow)this.translate(element)).setCurBalance(val);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }
}

