/*
 * Decompiled with CFR 0.152.
 */
package com.vela.balance.ui.parts;

import com.vela.balance.BalanceService;
import com.vela.balance.data.Balance;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class TitlePart {
    private NumberFormat numberFormatter = new DecimalFormat("#,###.00");
    @Inject
    private MDirtyable dirty;
    @Inject
    BalanceService balanceSrv;
    @Inject
    MPart part;
    private Text tDescription = null;
    private Text tDividend = null;
    private Button[] bSectors = null;
    private boolean noEvt = false;
    private static final String[] activities = new String[]{"Agricoltura, Silvicoltura, Pesca", "Estrazione, Manifattura, Produzione energia", "Forn.acqua reti fognarie rifiuti - Trasm.energia/gas", "Costruzione edifici", "Ingegneria civile, costruzioni specializzate", "Comm.ingrosso, Distr.energia/gas, Vendita Auto", "Commercio al dett, Bar, Ristoranti", "Hotel, trasporti e magazzinaggio", "Servizi alle imprese", "Servizi alle persone"};

    @PostConstruct
    public void createComposite(Composite parent) {
        Balance balance = this.balanceSrv.getBalanceTemplate();
        parent.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(parent, 0);
        l.setText("Nome societ\u00e0");
        this.tDescription = new Text(parent, 2048);
        this.tDescription.setLayoutData((Object)new GridData(768));
        this.tDescription.setText(balance.getDescription());
        this.tDescription.addListener(24, lst -> {
            this.noEvt = true;
            balance.setDescription(this.tDescription.getText());
            this.noEvt = false;
        });
        l = new Label(parent, 0);
        l.setText("Esercizio precedente");
        Spinner sLapse1 = new Spinner(parent, 2048);
        sLapse1.setValues(balance.getLapse1(), 2000, 9999, 0, 1, 10);
        sLapse1.addListener(24, lst -> {
            this.noEvt = true;
            balance.setLapse1(sLapse1.getSelection());
            this.noEvt = false;
        });
        l = new Label(parent, 0);
        l.setText("Esercizio");
        Spinner sLapse2 = new Spinner(parent, 2048);
        sLapse2.setValues(balance.getLapse2(), 2000, 9999, 0, 1, 10);
        sLapse2.addListener(24, lst -> {
            this.noEvt = true;
            balance.setLapse2(sLapse2.getSelection());
            this.noEvt = false;
        });
        Group sectors = new Group(parent, 0);
        sectors.setText("Settore attivit\u00e0");
        sectors.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        sectors.setLayout((Layout)new GridLayout(1, false));
        this.bSectors = new Button[activities.length];
        int i = 0;
        while (i < this.bSectors.length) {
            this.bSectors[i] = new Button((Composite)sectors, 16);
            this.bSectors[i].setText(activities[i].toString());
            this.bSectors[i].addListener(13, lst -> {
                this.noEvt = true;
                boolean[] sec = new boolean[this.bSectors.length];
                int j = 0;
                while (j < sec.length) {
                    sec[j] = this.bSectors[j].getSelection();
                    ++j;
                }
                balance.setSectors(sec);
                this.noEvt = false;
            });
            ++i;
        }
        l = new Label(parent, 0);
        l.setText("Eventuali dividenti deliberati non ancora contabilizzati");
        this.tDividend = new Text(parent, 133120);
        GridData gd = new GridData();
        gd.widthHint = 250;
        this.tDividend.setLayoutData((Object)gd);
        this.tDividend.addListener(24, lst -> {
            this.noEvt = true;
            ParsePosition pp = new ParsePosition(0);
            Number n = this.numberFormatter.parse(this.tDividend.getText(), pp);
            balance.setDividend(new BigDecimal(n.toString()));
            this.noEvt = false;
            if (pp.getErrorIndex() >= 0) {
                this.tDividend.setText(this.numberFormatter.format(n));
            }
        });
        PropertyChangeListener pcl = v -> {
            if (this.noEvt) {
                return;
            }
            switch (v.getPropertyName()) {
                case "lapse1": {
                    sLapse1.setSelection(((Integer)v.getNewValue()).intValue());
                    break;
                }
                case "lapse2": {
                    sLapse2.setSelection(((Integer)v.getNewValue()).intValue());
                    break;
                }
                case "description": {
                    this.tDescription.setText((String)v.getNewValue());
                    break;
                }
                case "dividend": {
                    this.tDividend.setText(this.numberFormatter.format(v.getNewValue()));
                    break;
                }
                case "sectors": {
                    boolean[] vals = (boolean[])v.getNewValue();
                    int i = 0;
                    while (i < this.bSectors.length) {
                        this.bSectors[i].setSelection(vals[i]);
                        ++i;
                    }
                    break;
                }
            }
        };
        balance.addPropertyChangeListener(pcl);
    }

    @Focus
    public void setFocus() {
        this.tDescription.setFocus();
    }

    @Persist
    public void save() {
        this.dirty.setDirty(false);
    }
}

