/*
 * Decompiled with CFR 0.152.
 */
package com.vela.balance.excel.manager;

import com.google.gson.Gson;
import com.vela.balance.BalanceService;
import com.vela.balance.data.AssEntity;
import com.vela.balance.data.Balance;
import com.vela.balance.data.BalanceRow;
import com.vela.balance.data.BalanceSheet;
import com.vela.balance.excel.manager.ExcelWorker;
import com.vela.balance.excel.manager.WebEsporter;
import com.vela.balance.excel.manager.XbrlLoader;
import com.vela.balance.impl.data.AssEntityJpa;
import com.vela.balance.xbrl.FullClient;
import com.vela.common.db.IDBManager;
import com.vela.common.db.ProgramDefinition;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BalanceService.class}, property={"osgi.command.scope=test", "osgi.command.function=balanceServiceMgr"})
public class BalanceServiceImpl
implements BalanceService {
    private final ExcelWorker worker = new ExcelWorker();
    private Balance innerBalance = null;
    @Reference
    IDBManager dbService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Balance getBalanceTemplate() {
        if (this.innerBalance != null) {
            return this.innerBalance;
        }
        BalanceServiceImpl balanceServiceImpl = this;
        synchronized (balanceServiceImpl) {
            this.innerBalance = new Balance();
            this.innerBalance.addSheet(this.worker.loadSheet(0));
            this.innerBalance.addSheet(this.worker.loadSheet(1));
            return this.innerBalance;
        }
    }

    public boolean storeBalance(Path outputPath) throws IOException {
        this.worker.storeHeader(0, this.innerBalance.getDescription(), this.innerBalance.getLapse1(), this.innerBalance.getLapse2());
        this.worker.storeHeader1(7, this.innerBalance.getDividend(), this.innerBalance.getSectors());
        this.worker.storeSheet(0, (BalanceSheet)this.innerBalance.getSheets().get(0));
        this.worker.storeSheet(1, (BalanceSheet)this.innerBalance.getSheets().get(1));
        this.worker.cleanFormula();
        this.worker.save(outputPath);
        Gson gson = new Gson();
        Files.write(Paths.get(outputPath.toString().replaceAll("\\.xlsx$", ".vbil"), new String[0]), Arrays.asList(gson.toJson((Object)this.innerBalance)), Charset.forName("UTF-8"), new OpenOption[0]);
        return true;
    }

    public boolean loadBalance(Path inputPath) throws IOException {
        Gson gson = new Gson();
        StringBuilder sb = new StringBuilder();
        Throwable throwable = null;
        Object var5_7 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputPath.toFile()), "UTF8"));){
            String s = null;
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Balance _bal = (Balance)gson.fromJson(sb.toString(), Balance.class);
        this.innerBalance.loadData(_bal);
        return true;
    }

    public boolean loadXbrl(Path inputPath) throws IOException {
        XbrlLoader xl = new XbrlLoader();
        try {
            xl.loadXbrl(inputPath, this.innerBalance);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return true;
    }

    public File esportaWeb() throws IOException {
        WebEsporter xl = new WebEsporter();
        Path pathFile = null;
        try {
            FullClient full = xl.esporta(this.innerBalance);
            Gson gson = new Gson();
            String testo = gson.toJson((Object)full);
            pathFile = Files.createTempFile("esportazione", ".json", new FileAttribute[0]);
            Files.write(pathFile, testo.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            return null;
        }
        return pathFile.toFile();
    }

    public void shiftBalance() {
        this.innerBalance.shiftData();
    }

    public void syncBalance(BalanceSheet bs) {
        try (EntityManager em = this.dbService.getEntityManager(IDBManager.DBType.DB2, this.getClass().getClassLoader());){
            ArrayList<String> codici = new ArrayList<String>();
            for (BalanceRow bro : bs.getRows()) {
                if (!bro.isData()) continue;
                String code = bro.getCode();
                codici.add(code);
                TypedQuery query = em.createNamedQuery("listAssbyCode", AssEntity.class).setParameter("code", (Object)(code != null ? code : null));
                List ass = query.getResultList();
                BigDecimal risu = BigDecimal.ZERO;
                for (AssEntity element : ass) {
                    BigDecimal saldo;
                    BigDecimal bigDecimal = saldo = element.getBalance() == null ? BigDecimal.ZERO : element.getBalance().getSaldo();
                    if (!(code.startsWith("PA") || code.startsWith("EB") || code.startsWith("ECZ") || code.startsWith("EDH") || code.startsWith("EEY"))) {
                        code.startsWith("EEW");
                    }
                    if (code.startsWith("PP") || code.startsWith("EA") || code.startsWith("ECU") || code.startsWith("ECV") || code.startsWith("EDG") || code.startsWith("EEX")) {
                        saldo = saldo.multiply(BigDecimal.valueOf(-1L));
                    }
                    if (saldo.compareTo(BigDecimal.ZERO) >= 0) {
                        if (!element.getKeyD().equals(code)) continue;
                        risu = risu.add(saldo);
                        continue;
                    }
                    if (!element.getKeyA().equals(code)) continue;
                    risu = risu.add(saldo);
                }
                bro.setCurBalance(risu);
            }
        }
    }

    public String computeBalance(Calendar to, Calendar fromEco, boolean extra) {
        int d1 = to.get(1) * 10000 + (to.get(2) + 1) * 100 + to.get(5);
        int d2 = 0;
        if (fromEco != null) {
            d2 = fromEco.get(1) * 10000 + (fromEco.get(2) + 1) * 100 + fromEco.get(5);
        }
        Object[] parms = new Object[4];
        parms[0] = new BigDecimal(d1);
        parms[1] = new BigDecimal(d2);
        parms[2] = extra ? "1" : "0";
        char[] c = new char[80];
        Arrays.fill(c, ' ');
        parms[3] = new String(c);
        if (!this.dbService.call(IDBManager.DBType.DB2, new ProgramDefinition("XJGENBILC", "SAGAPGM", parms))) {
            throw new RuntimeException("Errore generico in fase di calcolo bilancio");
        }
        if (parms[3].toString().trim().isEmpty()) {
            return null;
        }
        return parms[3].toString().trim();
    }

    public List<? extends AssEntity> getAssEntities() {
        try (EntityManager em = this.dbService.getEntityManager(IDBManager.DBType.DB2, this.getClass().getClassLoader());){
            List list = em.createNamedQuery("listAssign", AssEntityJpa.class).getResultList();
            return list;
        }
    }

    public void storeAssEntity(List<? extends AssEntity> assEntities) {
        EntityManager em = this.dbService.getEntityManager(IDBManager.DBType.DB2, this.getClass().getClassLoader());
        try {
            em.getTransaction().begin();
            assEntities.stream().map(a -> (AssEntityJpa)a).forEach(a -> em.merge(a));
            em.getTransaction().commit();
        }
        finally {
            if (em != null) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

