/*
 * Decompiled with CFR 0.152.
 */
package com.vela.balance.excel.manager;

import com.vela.balance.data.BalanceRow;
import com.vela.balance.data.BalanceSheet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

class ExcelWorker
implements PropertyChangeListener {
    private Workbook workbook;
    private FormulaEvaluator formulaEval;
    private final Map<TotalFormula, BalanceRow> totalFormulaMap = new HashMap<TotalFormula, BalanceRow>();

    ExcelWorker() {
    }

    private Workbook loadWorkbook() {
        try {
            URL url = new URL("platform:/plugin/com.vela.balance.impl/sheet/bilancio.xlsx");
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (InputStream is = url.openStream();){
                    return new XSSFWorkbook(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Workbook getWorkbook() {
        if (this.workbook == null) {
            ExcelWorker excelWorker = this;
            synchronized (excelWorker) {
                this.workbook = this.loadWorkbook();
                return this.workbook;
            }
        }
        return this.workbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FormulaEvaluator getFormulaEval() {
        if (this.formulaEval == null) {
            ExcelWorker excelWorker = this;
            synchronized (excelWorker) {
                this.formulaEval = this.getWorkbook().getCreationHelper().createFormulaEvaluator();
                return this.formulaEval;
            }
        }
        return this.formulaEval;
    }

    BalanceSheet loadSheet(int nbr) {
        Sheet sheet = this.getWorkbook().getSheetAt(nbr);
        BalanceSheet bs = new BalanceSheet();
        bs.setTitle(sheet.getSheetName());
        IntStream.rangeClosed(sheet.getFirstRowNum(), sheet.getLastRowNum()).mapToObj(i -> this.buildRow(sheet, i)).filter(r -> r != null).forEach(r -> {
            bs.addRow(r);
            this.manageTotals((BalanceRow)r);
        });
        return bs;
    }

    private void manageTotals(BalanceRow r) {
        if (r.isTitle()) {
            return;
        }
        if (r.isTotal()) {
            if (r.getFormula() != null && !r.getFormula().isEmpty()) {
                this.totalFormulaMap.put(new TotalFormula(r.getFormula()), r);
            } else {
                this.totalFormulaMap.put(new TotalFormula(r.getCode()), r);
            }
        } else {
            r.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private BalanceRow buildRow(Sheet sheet, int i) {
        Optional<Row> row = Optional.ofNullable(sheet.getRow(i));
        if (!row.isPresent() || (row.get().getCell(5) == null || row.get().getCell(5).getStringCellValue().isEmpty()) && (row.get().getCell(6) == null || row.get().getCell(6).getStringCellValue().isEmpty())) {
            return null;
        }
        BalanceRow br = new BalanceRow();
        if (row.get().getCell(5) == null || row.get().getCell(5).getStringCellValue().isEmpty()) {
            br.setCode(row.get().getCell(6).getStringCellValue());
            br.setFormula(row.get().getCell(7) != null ? row.get().getCell(7).getStringCellValue() : null);
            br.setTotal(this.checkTotal(br));
            br.setTitle(!br.isTotal());
        } else {
            br.setCode(row.get().getCell(5).getStringCellValue());
            br.setFormula(null);
        }
        br.setDescription(row.get().getCell(0).getStringCellValue());
        br.setCurBalance(new BigDecimal("0"));
        br.setPrvBalance(new BigDecimal("0"));
        return br.getCode() != null ? br : null;
    }

    private boolean checkTotal(BalanceRow br) {
        return br.getCode() != null && !br.getCode().isEmpty() && br.getCode().endsWith("T") || br.getFormula() != null && !br.getFormula().isEmpty();
    }

    void cleanFormula() {
        IntStream.range(0, this.getWorkbook().getNumberOfSheets()).filter(i -> i >= 0).mapToObj(i -> this.getWorkbook().getSheetAt(i)).forEach(s -> this.cleanFormula((Sheet)s));
    }

    private void cleanFormula(Sheet s) {
        IntStream.rangeClosed(s.getFirstRowNum(), s.getLastRowNum()).filter(i -> i >= 0).mapToObj(i -> s.getRow(i)).filter(r -> r != null).forEach(r -> this.cleanFormula((Row)r));
    }

    private void cleanFormula(Row r) {
        IntStream.rangeClosed(r.getFirstCellNum(), r.getLastCellNum()).filter(i -> i >= 0).mapToObj(i -> r.getCell(i)).filter(c -> c != null).forEach(arg_0 -> ((FormulaEvaluator)this.getFormulaEval()).evaluateInCell(arg_0));
    }

    void save(Path outputPath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (OutputStream os = Files.newOutputStream(outputPath, new OpenOption[0]);){
                this.getWorkbook().write(os);
                this.clear();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void clear() {
        this.workbook = null;
        this.formulaEval = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            BalanceRow br = (BalanceRow)evt.getSource();
            String key = this.getTotalCode(br);
            do {
                Optional<BigDecimal> ol = Optional.ofNullable((BigDecimal)evt.getOldValue());
                Optional<BigDecimal> ne = Optional.ofNullable((BigDecimal)evt.getNewValue());
                for (TotalFormula formula : this.totalFormulaMap.keySet()) {
                    int result = formula.indexOf(key);
                    if (result < 0) continue;
                    BalanceRow totR = this.totalFormulaMap.get(formula);
                    boolean negative = formula.checkNegative(result);
                    if (totR == null) continue;
                    if (negative) {
                        if (evt.getPropertyName().equals("curBalance")) {
                            totR.setCurBalance(totR.getCurBalance().add(ol.orElse(new BigDecimal("0"))).subtract(ne.orElse(new BigDecimal("0"))));
                            continue;
                        }
                        totR.setPrvBalance(totR.getPrvBalance().add(ol.orElse(new BigDecimal("0"))).subtract(ne.orElse(new BigDecimal("0"))));
                        continue;
                    }
                    if (evt.getPropertyName().equals("curBalance")) {
                        totR.setCurBalance(totR.getCurBalance().subtract(ol.orElse(new BigDecimal("0"))).add(ne.orElse(new BigDecimal("0"))));
                        continue;
                    }
                    totR.setPrvBalance(totR.getPrvBalance().subtract(ol.orElse(new BigDecimal("0"))).add(ne.orElse(new BigDecimal("0"))));
                }
            } while ((key = key.substring(0, key.length() - 1)).length() > 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getTotalCode(BalanceRow r) {
        return r.getCode().substring(0, r.getCode().lastIndexOf(95));
    }

    public void storeSheet(int shnbr, BalanceSheet balanceSheet) {
        HashMap vals = new HashMap();
        balanceSheet.getRows().stream().filter(r -> r.isData()).forEach(r -> {
            BalanceRow balanceRow = vals.put(r.getCode(), r);
        });
        Sheet sheet = this.getWorkbook().getSheetAt(shnbr);
        IntStream.range(sheet.getFirstRowNum(), sheet.getLastRowNum()).forEach(i -> {
            if (sheet.getRow(i) == null) {
                return;
            }
            if (sheet.getRow(i).getCell(5) == null) {
                return;
            }
            if (sheet.getRow(i).getCell(5).getStringCellValue().isEmpty()) {
                return;
            }
            BalanceRow br = (BalanceRow)vals.get(sheet.getRow(i).getCell(5).getStringCellValue());
            if (br == null) {
                return;
            }
            sheet.getRow(i).getCell(1).setCellValue(br.getPrvBalance().doubleValue());
            sheet.getRow(i).getCell(2).setCellValue(br.getCurBalance().doubleValue());
        });
    }

    public void storeHeader(int i, String description, int lapse1, int lapse2) {
        Sheet sheet = this.getWorkbook().getSheetAt(i);
        sheet.getRow(0).getCell(0).setCellValue(description);
        sheet.getRow(1).getCell(1).setCellValue((double)lapse1);
        sheet.getRow(1).getCell(2).setCellValue((double)lapse2);
    }

    public void storeHeader1(int i, BigDecimal dividend, boolean[] sectors) {
        Sheet sheet = this.getWorkbook().getSheetAt(i);
        sheet.getRow(8).getCell(1).setCellValue(dividend.doubleValue());
        int j = 0;
        while (j < sectors.length) {
            sheet.getRow(17 + j).getCell(5).setCellValue(sectors[j]);
            ++j;
        }
    }

    private class TotalFormula {
        private final String[] keys;
        private final boolean[] negative;
        private static final String SEPARATOR = ";";

        TotalFormula(String source) {
            String[] tmp = source.split(SEPARATOR);
            this.keys = new String[tmp.length];
            this.negative = new boolean[tmp.length];
            this.buildFormula(tmp);
        }

        public boolean checkNegative(int result) {
            return this.negative[result];
        }

        public int indexOf(String key) {
            int i = 0;
            while (i < this.keys.length) {
                if (this.keys[i].equals(key)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void buildFormula(String[] tmp) {
            int i = 0;
            while (i < tmp.length) {
                this.negative[i] = tmp[i].startsWith("-");
                this.keys[i] = this.negative[i] ? tmp[i].substring(1) : tmp[i];
                this.keys[i] = this.keys[i].substring(0, this.keys[i].lastIndexOf(95));
                ++i;
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + Arrays.hashCode(this.keys);
            result = 31 * result + Arrays.hashCode(this.negative);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TotalFormula other = (TotalFormula)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (!Arrays.equals(this.keys, other.keys)) {
                return false;
            }
            return Arrays.equals(this.negative, other.negative);
        }

        private ExcelWorker getOuterType() {
            return ExcelWorker.this;
        }
    }
}

