/*
 * Decompiled with CFR 0.152.
 */
package com.vela.balance.excel.manager;

import com.vela.balance.data.Balance;
import com.vela.balance.xbrl.FullClient;
import com.vela.balance.xbrl.QDimAB;
import it.infocamere.banx.teni.xbrl.QDimToXBRLNS;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class XbrlLoader {
    public Balance loadXbrl(Path inputPath, Balance innerBalance) throws Exception {
        Map<String, String> mappaDate;
        QDimAB Data = new QDimAB();
        QDimToXBRLNS Q = new QDimToXBRLNS();
        Path outF1 = null;
        Path outF2 = null;
        String balanceType = null;
        URL url1 = new URL("platform:/plugin/com.vela.balance.impl/xbrlasset/mapping.xml");
        try {
            outF1 = Files.createTempFile("mapping", ".xml", new FileAttribute[0]);
            Files.copy(url1.openStream(), outF1, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        URL url2 = new URL("platform:/plugin/com.vela.balance.impl/xbrlasset/report.xml");
        try {
            outF2 = Files.createTempFile("report", ".xml", new FileAttribute[0]);
            Files.copy(url2.openStream(), outF2, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        String xbrlAssetsFolder = outF1.getParent().toString();
        try {
            Q.mappingDoc = Q.readXMLQDimFile(xbrlAssetsFolder, "" + outF1.getFileName());
            Q.reportDoc = Q.readXMLQDimFile(xbrlAssetsFolder, "" + outF2.getFileName());
            String taxoDate = "2018-11-04";
            Q.setMappingMap(Q.mappingDoc);
            Q.XBRLInstanceDoc = Data.changeTaxoDate(XbrlLoader.parseXML(inputPath.toString()), taxoDate);
            balanceType = XbrlLoader.getBalanceType(Q.XBRLInstanceDoc);
            System.out.println("Tipo bilancio: " + balanceType);
            if (!balanceType.equals("ese")) {
                throw new RuntimeException("Formato bilancio non in versione estesa! Non sar\u00e0 possibile il caricamento");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        String QDimData = null;
        try {
            QDimData = Q.transformXBRLInstanceStr();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Document doc = DocumentHelper.parseText((String)QDimData);
        String denom = XbrlLoader.getDenominazione(doc);
        if (denom != null) {
            innerBalance.setDescription(denom);
        }
        if ((mappaDate = XbrlLoader.getStartDate(doc)).containsKey("annoprec")) {
            int a1 = Integer.valueOf(mappaDate.get("annoprec"));
            int a2 = Integer.valueOf(mappaDate.get("annoatt"));
            innerBalance.setLapse1(a1);
            innerBalance.setLapse2(a2);
        }
        Map<String, String> mappaSP = XbrlLoader.creaMappaSP();
        Map<String, String> mappaCE = XbrlLoader.creaMappaCE();
        FullClient full = Data.importXMLInstanceNew(doc, Q.mappingMap, mappaSP, mappaCE);
        innerBalance = this.settaCampi(full, innerBalance);
        return innerBalance;
    }

    protected static Document parseXML(String xmlFilePath) throws Exception {
        SAXReader reader = new SAXReader();
        reader.setMergeAdjacentText(true);
        reader.setStripWhitespaceText(true);
        String escapedString = "";
        try {
            escapedString = Files.readString(Paths.get(xmlFilePath, new String[0]));
        }
        catch (Exception e) {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(xmlFilePath), "utf-8"));){
                escapedString = br.lines().collect(Collectors.joining());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        String unEscapedHTML = StringEscapeUtils.unescapeHtml4((String)escapedString);
        System.out.println(unEscapedHTML);
        return reader.read((Reader)new BufferedReader(new StringReader(unEscapedHTML)));
    }

    public static String getBalanceType(Document doc) {
        Element XBRLRoot = doc.getRootElement();
        return XBRLRoot.element("schemaRef").attributeValue("href").split("-")[2];
    }

    public static Map<String, String> getStartDate(Document doc) {
        XPath xpath = DocumentHelper.createXPath((String)"instance/context");
        XPath sortXPath = DocumentHelper.createXPath((String)"period/endDate");
        List cntxList = xpath.selectNodes((Object)doc, sortXPath);
        ListIterator iter = cntxList.listIterator();
        HashMap<String, String> anni = new HashMap<String, String>();
        while (iter.hasNext()) {
            Node cntx = (Node)iter.next();
            if (cntx.valueOf("@id").equals("c0")) {
                String annoprec = cntx.valueOf("period/startDate").substring(0, 4);
                anni.put("annoprec", annoprec);
            }
            if (!cntx.valueOf("@id").equals("c1")) continue;
            String annoatt = cntx.valueOf("period/startDate").substring(0, 4);
            anni.put("annoatt", annoatt);
        }
        return anni;
    }

    public static String getDenominazione(Document doc) {
        List factList = doc.selectNodes("instance/fact");
        ListIterator iter = factList.listIterator();
        while (iter.hasNext()) {
            Element fact = (Element)iter.next();
            if (!fact.valueOf("@cell_code").equals("T0000.D01.1.001.002.002")) continue;
            return fact.getText();
        }
        return null;
    }

    public static Map<String, String> creaMappaSP() {
        HashMap<String, String> mappaSP = new HashMap<String, String>();
        mappaSP.put("T0001.D01.1.001.002.002.002.000.000.000", "6");
        mappaSP.put("T0001.D01.1.001.002.002.003.000.000.000", "7");
        mappaSP.put("T0001.D01.1.001.002.003.002.002.000.000", "12");
        mappaSP.put("T0001.D01.1.001.002.003.002.003.000.000", "13");
        mappaSP.put("T0001.D01.1.001.002.003.002.004.000.000", "14");
        mappaSP.put("T0001.D01.1.001.002.003.002.005.000.000", "15");
        mappaSP.put("T0001.D01.1.001.002.003.002.006.000.000", "16");
        mappaSP.put("T0001.D01.1.001.002.003.002.007.000.000", "17");
        mappaSP.put("T0001.D01.1.001.002.003.002.008.000.000", "18");
        mappaSP.put("T0001.D01.1.001.002.003.003.002.000.000", "21");
        mappaSP.put("T0001.D01.1.001.002.003.003.003.000.000", "22");
        mappaSP.put("T0001.D01.1.001.002.003.003.004.000.000", "23");
        mappaSP.put("T0001.D01.1.001.002.003.003.005.000.000", "24");
        mappaSP.put("T0001.D01.1.001.002.003.003.006.000.000", "25");
        mappaSP.put("T0001.D01.1.001.002.003.004.002.002.000", "29");
        mappaSP.put("T0001.D01.1.001.002.003.004.002.003.000", "30");
        mappaSP.put("T0001.D01.1.001.002.003.004.002.004.000", "31-a");
        mappaSP.put("T0001.D01.1.001.002.003.004.002.005.000", "31-z");
        mappaSP.put("T0001.D01.1.001.002.003.004.002.006.000", "32");
        mappaSP.put("T0001.D01.1.001.002.003.004.003.002.002", "36");
        mappaSP.put("T0001.D01.1.001.002.003.004.003.002.003", "37");
        mappaSP.put("T0001.D01.1.001.002.003.004.003.003.002", "40");
        mappaSP.put("T0001.D01.1.001.002.003.004.003.003.003", "41");
        mappaSP.put("T0001.D01.1.001.002.003.004.003.004.002", "44");
        mappaSP.put("T0001.D01.1.001.002.003.004.003.004.003", "45");
        mappaSP.put("T0001.D01.1.001.002.003.004.003.005.002", "51-a");
        mappaSP.put("T0001.D01.1.001.002.003.004.003.005.003", "52-a");
        mappaSP.put("T0001.D01.1.001.002.003.004.003.006.002", "51-z");
        mappaSP.put("T0001.D01.1.001.002.003.004.003.006.003", "52-z");
        mappaSP.put("T0001.D01.1.001.002.003.004.004.000.000", "55");
        mappaSP.put("T0001.D01.1.001.002.003.004.005.000.000", "56");
        mappaSP.put("T0001.D01.1.001.002.004.002.002.000.000", "62");
        mappaSP.put("T0001.D01.1.001.002.004.002.003.000.000", "63");
        mappaSP.put("T0001.D01.1.001.002.004.002.004.000.000", "64");
        mappaSP.put("T0001.D01.1.001.002.004.002.005.000.000", "65");
        mappaSP.put("T0001.D01.1.001.002.004.002.006.000.000", "66");
        mappaSP.put("T0001.D01.1.001.002.004.004.002.002.000", "70");
        mappaSP.put("T0001.D01.1.001.002.004.004.002.003.000", "71");
        mappaSP.put("T0001.D01.1.001.002.004.004.003.002.000", "74-a");
        mappaSP.put("T0001.D01.1.001.002.004.004.003.003.000", "74-z");
        mappaSP.put("T0001.D01.1.001.002.004.004.004.002.000", "79");
        mappaSP.put("T0001.D01.1.001.002.004.004.004.003.000", "80");
        mappaSP.put("T0001.D01.1.001.002.004.004.005.002.000", "84-a");
        mappaSP.put("T0001.D01.1.001.002.004.004.005.003.000", "85-a");
        mappaSP.put("T0001.D01.1.001.002.004.004.006.002.000", "84-z");
        mappaSP.put("T0001.D01.1.001.002.004.004.006.003.000", "85-z");
        mappaSP.put("T0001.D01.1.001.002.004.004.007.002.000", "89");
        mappaSP.put("T0001.D01.1.001.002.004.004.007.003.000", "90");
        mappaSP.put("T0001.D01.1.001.002.004.004.008.000.000", "93");
        mappaSP.put("T0001.D01.1.001.002.004.004.009.002.000", "97");
        mappaSP.put("T0001.D01.1.001.002.004.004.009.003.000", "98");
        mappaSP.put("T0001.D01.1.001.002.004.005.002.000.000", "102");
        mappaSP.put("T0001.D01.1.001.002.004.005.003.000.000", "103");
        mappaSP.put("T0001.D01.1.001.002.004.005.004.000.000", "104-a");
        mappaSP.put("T0001.D01.1.001.002.004.005.005.000.000", "104-z");
        mappaSP.put("T0001.D01.1.001.002.004.005.006.000.000", "105");
        mappaSP.put("T0001.D01.1.001.002.004.005.007.000.000", "106");
        mappaSP.put("T0001.D01.1.001.002.004.005.008.000.000", "107");
        mappaSP.put("T0001.D01.1.001.002.004.006.002.000.000", "110");
        mappaSP.put("T0001.D01.1.001.002.004.006.003.000.000", "111");
        mappaSP.put("T0001.D01.1.001.002.004.006.004.000.000", "112");
        mappaSP.put("T0001.D01.1.001.002.005.000.000.000.000", "117");
        mappaSP.put("T0001.D01.1.001.002.006.000.000.000.000", "121");
        mappaSP.put("T0001.D01.1.001.003.002.002.000.000.000", "127");
        mappaSP.put("T0001.D01.1.001.003.002.003.000.000.000", "128");
        mappaSP.put("T0001.D01.1.001.003.002.004.000.000.000", "129");
        mappaSP.put("T0001.D01.1.001.003.002.005.000.000.000", "130");
        mappaSP.put("T0001.D01.1.001.003.002.006.000.000.000", "131");
        mappaSP.put("T0001.D01.1.001.003.002.007.002.000.000", "134");
        mappaSP.put("T0001.D01.1.001.003.002.007.003.000.000", "138");
        mappaSP.put("T0001.D01.1.001.003.002.007.004.000.000", "139");
        mappaSP.put("T0001.D01.1.001.003.002.007.005.000.000", "140");
        mappaSP.put("T0001.D01.1.001.003.002.007.006.000.000", "141");
        mappaSP.put("T0001.D01.1.001.003.002.007.007.000.000", "142");
        mappaSP.put("T0001.D01.1.001.003.002.007.008.000.000", "143");
        mappaSP.put("T0001.D01.1.001.003.002.007.009.000.000", "144");
        mappaSP.put("T0001.D01.1.001.003.002.007.010.000.000", "145");
        mappaSP.put("T0001.D01.1.001.003.002.007.011.000.000", "146");
        mappaSP.put("T0001.D01.1.001.003.002.007.012.000.000", "147-a");
        mappaSP.put("T0001.D01.1.001.003.002.008.000.000.000", "147-z");
        mappaSP.put("T0001.D01.1.001.003.002.007.014.000.000", "155");
        mappaSP.put("T0001.D01.1.001.003.002.009.000.000.000", "157");
        mappaSP.put("T0001.D01.1.001.003.002.010.000.000.000", "159");
        mappaSP.put("T0001.D01.1.001.003.003.002.000.000.000", "165");
        mappaSP.put("T0001.D01.1.001.003.003.003.000.000.000", "166");
        mappaSP.put("T0001.D01.1.001.003.003.004.000.000.000", "167-a");
        mappaSP.put("T0001.D01.1.001.003.003.005.000.000.000", "167-z");
        mappaSP.put("T0001.D01.1.001.003.004.000.000.000.000", "169");
        mappaSP.put("T0001.D01.1.001.003.005.002.002.000.000", "172");
        mappaSP.put("T0001.D01.1.001.003.005.002.003.000.000", "173");
        mappaSP.put("T0001.D01.1.001.003.005.003.002.000.000", "176");
        mappaSP.put("T0001.D01.1.001.003.005.003.003.000.000", "177");
        mappaSP.put("T0001.D01.1.001.003.005.004.002.000.000", "180");
        mappaSP.put("T0001.D01.1.001.003.005.004.003.000.000", "181");
        mappaSP.put("T0001.D01.1.001.003.005.005.002.000.000", "184");
        mappaSP.put("T0001.D01.1.001.003.005.005.003.000.000", "185");
        mappaSP.put("T0001.D01.1.001.003.005.006.002.000.000", "188");
        mappaSP.put("T0001.D01.1.001.003.005.006.003.000.000", "189");
        mappaSP.put("T0001.D01.1.001.003.005.007.002.000.000", "192");
        mappaSP.put("T0001.D01.1.001.003.005.007.003.000.000", "193");
        mappaSP.put("T0001.D01.1.001.003.005.008.002.000.000", "196");
        mappaSP.put("T0001.D01.1.001.003.005.008.003.000.000", "197");
        mappaSP.put("T0001.D01.1.001.003.005.009.002.000.000", "201");
        mappaSP.put("T0001.D01.1.001.003.005.009.003.000.000", "202");
        mappaSP.put("T0001.D01.1.001.003.005.010.002.000.000", "205");
        mappaSP.put("T0001.D01.1.001.003.005.010.003.000.000", "207");
        mappaSP.put("T0001.D01.1.001.003.005.011.002.000.000", "211");
        mappaSP.put("T0001.D01.1.001.003.005.011.003.000.000", "212");
        mappaSP.put("T0001.D01.1.001.003.005.012.002.000.000", "217-a");
        mappaSP.put("T0001.D01.1.001.003.005.012.003.000.000", "218-a");
        mappaSP.put("T0001.D01.1.001.003.005.013.002.000.000", "217-z");
        mappaSP.put("T0001.D01.1.001.003.005.013.003.000.000", "218-z");
        mappaSP.put("T0001.D01.1.001.003.005.014.002.000.000", "223");
        mappaSP.put("T0001.D01.1.001.003.005.014.003.000.000", "224");
        mappaSP.put("T0001.D01.1.001.003.005.015.002.000.000", "227");
        mappaSP.put("T0001.D01.1.001.003.005.015.003.000.000", "228");
        mappaSP.put("T0001.D01.1.001.003.005.016.002.000.000", "231");
        mappaSP.put("T0001.D01.1.001.003.005.016.003.000.000", "232");
        mappaSP.put("T0001.D01.1.001.003.006.000.000.000.000", "237");
        mappaSP.put("T0001.D01.1.001.003.007.000.000.000.000", "241");
        return mappaSP;
    }

    public static Map<String, String> creaMappaCE() {
        HashMap<String, String> mappaCE = new HashMap<String, String>();
        mappaCE.put("T0005.D01.1.001.002.002.000.000", "7");
        mappaCE.put("T0005.D01.1.001.002.003.000.000", "8");
        mappaCE.put("T0005.D01.1.001.002.004.000.000", "9");
        mappaCE.put("T0005.D01.1.001.002.005.000.000", "10");
        mappaCE.put("T0005.D01.1.001.002.006.002.000", "12-a");
        mappaCE.put("T0005.D01.1.001.002.006.003.000", "12-z");
        mappaCE.put("T0005.D01.1.001.003.002.000.000", "17");
        mappaCE.put("T0005.D01.1.001.003.003.000.000", "18");
        mappaCE.put("T0005.D01.1.001.003.004.000.000", "19");
        mappaCE.put("T0005.D01.1.001.003.005.002.000", "21");
        mappaCE.put("T0005.D01.1.001.003.005.003.000", "22");
        mappaCE.put("T0005.D01.1.001.003.005.004.000", "23");
        mappaCE.put("T0005.D01.1.001.003.005.005.000", "24");
        mappaCE.put("T0005.D01.1.001.003.005.006.000", "25");
        mappaCE.put("T0005.D01.1.001.003.006.002.000", "28");
        mappaCE.put("T0005.D01.1.001.003.006.003.000", "29");
        mappaCE.put("T0005.D01.1.001.003.006.004.000", "30");
        mappaCE.put("T0005.D01.1.001.003.006.005.000", "31");
        mappaCE.put("T0005.D01.1.001.003.007.000.000", "33");
        mappaCE.put("T0005.D01.1.001.003.008.000.000", "34");
        mappaCE.put("T0005.D01.1.001.003.009.000.000", "35");
        mappaCE.put("T0005.D01.1.001.003.010.000.000", "36");
        mappaCE.put("T0005.D01.1.001.004.000.000.000", "39");
        mappaCE.put("T0005.D01.1.001.005.002.002.000", "43");
        mappaCE.put("T0005.D01.1.001.005.002.003.000", "44");
        mappaCE.put("T0005.D01.1.001.005.002.004.000", "45-a");
        mappaCE.put("T0005.D01.1.001.005.002.005.000", "45-b");
        mappaCE.put("T0005.D01.1.001.005.002.006.000", "45-z");
        mappaCE.put("T0005.D01.1.001.005.003.002.002", "49");
        mappaCE.put("T0005.D01.1.001.005.003.002.003", "50");
        mappaCE.put("T0005.D01.1.001.005.003.002.004", "51-a");
        mappaCE.put("T0005.D01.1.001.005.003.002.005", "51-z");
        mappaCE.put("T0005.D01.1.001.005.003.002.006", "52");
        mappaCE.put("T0005.D01.1.001.005.003.003.000", "58");
        mappaCE.put("T0005.D01.1.001.005.003.004.000", "59");
        mappaCE.put("T0005.D01.1.001.005.003.005.002", "61");
        mappaCE.put("T0005.D01.1.001.005.003.005.003", "62");
        mappaCE.put("T0005.D01.1.001.005.003.005.004", "63");
        mappaCE.put("T0005.D01.1.001.005.003.005.005", "64-a");
        mappaCE.put("T0005.D01.1.001.005.003.005.006", "64-z");
        mappaCE.put("T0005.D01.1.001.005.004.002.000", "69");
        mappaCE.put("T0005.D01.1.001.005.004.003.000", "70");
        mappaCE.put("T0005.D01.1.001.005.004.004.000", "71");
        mappaCE.put("T0005.D01.1.001.005.004.005.000", "72-a");
        mappaCE.put("T0005.D01.1.001.005.004.006.000", "72-z");
        mappaCE.put("T0005.D01.1.001.005.005.000.000", "75");
        mappaCE.put("T0005.D01.1.001.006.002.002.000", "81");
        mappaCE.put("T0005.D01.1.001.006.002.003.000", "82");
        mappaCE.put("T0005.D01.1.001.006.002.004.000", "83");
        mappaCE.put("T0005.D01.1.001.006.002.005.000", "83-a");
        mappaCE.put("T0005.D01.1.001.006.002.006.000", "83-z");
        mappaCE.put("T0005.D01.1.001.006.003.002.000", "86");
        mappaCE.put("T0005.D01.1.001.006.003.003.000", "87");
        mappaCE.put("T0005.D01.1.001.006.003.004.000", "88-a");
        mappaCE.put("T0005.D01.1.001.006.003.005.000", "88-b");
        mappaCE.put("T0005.D01.1.001.006.003.006.000", "88-z");
        mappaCE.put("T0005.D01.1.001.008.002.000.000", "110");
        mappaCE.put("T0005.D01.1.001.009.000.000.000", "115");
        mappaCE.put("T0005.D01.1.001.008.003.000.000", "130");
        mappaCE.put("T0005.D01.1.001.008.004.000.000", "131");
        mappaCE.put("T0005.D01.1.001.008.005.000.000", "132");
        return mappaCE;
    }

    public static Map<String, String> creaMappaAB() {
        HashMap<String, String> mappaAB = new HashMap<String, String>();
        mappaAB.put("3", "SP3_");
        mappaAB.put("4", "PA_");
        mappaAB.put("5", "PAA_");
        mappaAB.put("6", "PAA_r");
        mappaAB.put("7", "PAA_d");
        mappaAB.put("8", "PAA_T");
        mappaAB.put("10", "PAB_");
        mappaAB.put("11", "PAB1_");
        mappaAB.put("12", "PAB1_1");
        mappaAB.put("13", "PAB1_2");
        mappaAB.put("14", "PAB1_3");
        mappaAB.put("15", "PAB1_4");
        mappaAB.put("16", "PAB1_5");
        mappaAB.put("17", "PAB1_6");
        mappaAB.put("18", "PAB1_7");
        mappaAB.put("19", "PAB1_T");
        mappaAB.put("20", "PAB2_");
        mappaAB.put("21", "PAB2_1");
        mappaAB.put("22", "PAB2_2");
        mappaAB.put("23", "PAB2_3");
        mappaAB.put("24", "PAB2_4");
        mappaAB.put("25", "PAB2_5");
        mappaAB.put("26", "PAB2_T");
        mappaAB.put("27", "PAB3_");
        mappaAB.put("28", "PAB31_");
        mappaAB.put("29", "PAB31_a");
        mappaAB.put("30", "PAB31_b");
        mappaAB.put("31", "PAB31_c");
        mappaAB.put("32", "PAB31_d");
        mappaAB.put("33", "PAB31_T");
        mappaAB.put("34", "PAB32_");
        mappaAB.put("35", "PAB32a_");
        mappaAB.put("36", "PAB32a_e");
        mappaAB.put("37", "PAB32a_s");
        mappaAB.put("38", "PAB32a_T");
        mappaAB.put("39", "PAB32b_");
        mappaAB.put("40", "PAB32b_e");
        mappaAB.put("41", "PAB32b_s");
        mappaAB.put("42", "PAB32b_T");
        mappaAB.put("43", "PAB32c_");
        mappaAB.put("44", "PAB32c_e");
        mappaAB.put("45", "PAB32c_s");
        mappaAB.put("46", "PAB32c_T");
        mappaAB.put("50", "PAB32d_");
        mappaAB.put("51", "PAB32d_e");
        mappaAB.put("52", "PAB32d_s");
        mappaAB.put("53", "PAB32d_T");
        mappaAB.put("54", "PAB32_T");
        mappaAB.put("55", "PAB33t_");
        mappaAB.put("56", "PAB33p_");
        mappaAB.put("57", "PAB3_T");
        mappaAB.put("58", "PAB_T");
        mappaAB.put("60", "PAC_");
        mappaAB.put("61", "PAC1_");
        mappaAB.put("62", "PAC1_1");
        mappaAB.put("63", "PAC1_2");
        mappaAB.put("64", "PAC1_3");
        mappaAB.put("65", "PAC1_4");
        mappaAB.put("66", "PAC1_5");
        mappaAB.put("67", "PAC1_T");
        mappaAB.put("68", "PAC2_");
        mappaAB.put("69", "PAC21_");
        mappaAB.put("70", "PAC21_e");
        mappaAB.put("71", "PAC21_s");
        mappaAB.put("72", "PAC21_T");
        mappaAB.put("73", "PAC22_");
        mappaAB.put("74", "PAC22_e");
        mappaAB.put("75", "PAC22_f");
        mappaAB.put("76", "PAC22_s");
        mappaAB.put("77", "PAC22_T");
        mappaAB.put("78", "PAC23_");
        mappaAB.put("79", "PAC23_e");
        mappaAB.put("80", "PAC23_f");
        mappaAB.put("81", "PAC23_s");
        mappaAB.put("82", "PAC23_T");
        mappaAB.put("83", "PAC24a_");
        mappaAB.put("84", "PAC24a_e");
        mappaAB.put("85", "PAC24a_f");
        mappaAB.put("86", "PAC24a_s");
        mappaAB.put("87", "PAC24a_T");
        mappaAB.put("88", "PAC24b_");
        mappaAB.put("89", "PAC24b_e");
        mappaAB.put("90", "PAC24b_s");
        mappaAB.put("91", "PAC24b_T");
        mappaAB.put("92", "PAC24t_");
        mappaAB.put("93", "PAC24t_e");
        mappaAB.put("94", "PAC24t_s");
        mappaAB.put("95", "PAC24t_T");
        mappaAB.put("96", "PAC25t_");
        mappaAB.put("97", "PAC25t_e");
        mappaAB.put("98", "PAC25t_s");
        mappaAB.put("99", "PAC25t_T");
        mappaAB.put("100", "PAC2_T");
        mappaAB.put("101", "PAC3_");
        mappaAB.put("102", "PAC3_1");
        mappaAB.put("103", "PAC3_2");
        mappaAB.put("104", "PAC3_3");
        mappaAB.put("105", "PAC3_4");
        mappaAB.put("106", "PAC3_5");
        mappaAB.put("107", "PAC3_6");
        mappaAB.put("108", "PAC3_T");
        mappaAB.put("109", "PAC4_");
        mappaAB.put("110", "PAC4_1");
        mappaAB.put("111", "PAC4_2");
        mappaAB.put("112", "PAC4_3");
        mappaAB.put("113", "PAC4_T");
        mappaAB.put("114", "PAC_T");
        mappaAB.put("116", "PAD_");
        mappaAB.put("117", "PAD_r");
        mappaAB.put("118", "PAD_d");
        mappaAB.put("119", "PAD_T");
        mappaAB.put("121", "PA_T");
        mappaAB.put("125", "PP_");
        mappaAB.put("126", "PPA_");
        mappaAB.put("127", "PPA1_");
        mappaAB.put("128", "PPA2_");
        mappaAB.put("129", "PPA3_");
        mappaAB.put("130", "PPA4_");
        mappaAB.put("131", "PPA5_");
        mappaAB.put("132", "PPA6_");
        mappaAB.put("133", "PPA7a_T");
        mappaAB.put("134", "PPA7a_1");
        mappaAB.put("135", "PPA7a_2");
        mappaAB.put("136", "PPA7a_3");
        mappaAB.put("137", "PPA7a_4");
        mappaAB.put("138", "PPA7a_5");
        mappaAB.put("139", "PPA7a_6");
        mappaAB.put("140", "PPA7a_7");
        mappaAB.put("141", "PPA7a_8");
        mappaAB.put("142", "PPA7a_9");
        mappaAB.put("143", "PPA7a_10");
        mappaAB.put("144", "PPA7a_11");
        mappaAB.put("145", "PPA7a_12");
        mappaAB.put("146", "PPA7a_13");
        mappaAB.put("147", "PPA7a_14");
        mappaAB.put("148", "PPA7a_15");
        mappaAB.put("149", "PPA7b_17");
        mappaAB.put("150", "PPA7b_17a");
        mappaAB.put("151", "PPA7b_17b");
        mappaAB.put("152", "PPA7b_17c");
        mappaAB.put("153", "PPA7b_17d");
        mappaAB.put("154", "PPA7b_17T");
        mappaAB.put("156", "PPA7_T");
        mappaAB.put("157", "PPA8_");
        mappaAB.put("158", "PPA9_");
        mappaAB.put("159", "PPA9_a");
        mappaAB.put("160", "PPA9_b");
        mappaAB.put("161", "PPA9_c");
        mappaAB.put("162", "PPA9_T");
        mappaAB.put("163", "PPA_T");
        mappaAB.put("164", "PPB_");
        mappaAB.put("165", "PPB_1");
        mappaAB.put("166", "PPB_2");
        mappaAB.put("167", "PPB_3");
        mappaAB.put("168", "PPB_T");
        mappaAB.put("169", "PPC_");
        mappaAB.put("170", "PPD_");
        mappaAB.put("171", "PPD1_");
        mappaAB.put("172", "PPD1_s");
        mappaAB.put("173", "PPD1_e");
        mappaAB.put("174", "PPD1_T");
        mappaAB.put("175", "PPD2_");
        mappaAB.put("176", "PPD2_s");
        mappaAB.put("177", "PPD2_e");
        mappaAB.put("178", "PPD2_T");
        mappaAB.put("179", "PPD3_");
        mappaAB.put("180", "PPD3_s");
        mappaAB.put("181", "PPD3_e");
        mappaAB.put("182", "PPD3_T");
        mappaAB.put("183", "PPD4_");
        mappaAB.put("184", "PPD4_s");
        mappaAB.put("185", "PPD4_e");
        mappaAB.put("186", "PPD4_T");
        mappaAB.put("187", "PPD5_");
        mappaAB.put("188", "PPD5_s");
        mappaAB.put("189", "PPD5_e");
        mappaAB.put("190", "PPD5_T");
        mappaAB.put("191", "PPD6_");
        mappaAB.put("192", "PPD6_s");
        mappaAB.put("193", "PPD6_e");
        mappaAB.put("194", "PPD6_T");
        mappaAB.put("195", "PPD7_");
        mappaAB.put("196", "PPD7_s");
        mappaAB.put("197", "PPD7_e");
        mappaAB.put("198", "PPD7_T");
        mappaAB.put("200", "PPD8_");
        mappaAB.put("201", "PPD8_s");
        mappaAB.put("202", "PPD8_e");
        mappaAB.put("203", "PPD8_T");
        mappaAB.put("204", "PPD9_");
        mappaAB.put("205", "PPD9_ec");
        mappaAB.put("206", "PPD9_ef");
        mappaAB.put("207", "PPD9_sf");
        mappaAB.put("208", "PPD9_sc");
        mappaAB.put("209", "PPD9_T");
        mappaAB.put("210", "PPDM_");
        mappaAB.put("211", "PPDM_ec");
        mappaAB.put("212", "PPDM_ef");
        mappaAB.put("213", "PPDM_sf");
        mappaAB.put("214", "PPDM_sc");
        mappaAB.put("215", "PPDM_T");
        mappaAB.put("216", "PPDN_");
        mappaAB.put("217", "PPDN_ec");
        mappaAB.put("218", "PPDN_ef");
        mappaAB.put("219", "PPDN_sf");
        mappaAB.put("220", "PPDN_sc");
        mappaAB.put("221", "PPDN_T");
        mappaAB.put("222", "PPDP_");
        mappaAB.put("223", "PPDP_s");
        mappaAB.put("224", "PPDP_e");
        mappaAB.put("225", "PPDP_T");
        mappaAB.put("226", "PPDR_");
        mappaAB.put("227", "PPDR_s");
        mappaAB.put("228", "PPDR_e");
        mappaAB.put("229", "PPDR_T");
        mappaAB.put("230", "PPDS_");
        mappaAB.put("231", "PPDS_s");
        mappaAB.put("232", "PPDS_e");
        mappaAB.put("233", "PPDS_T");
        mappaAB.put("234", "PPD_T");
        mappaAB.put("236", "PPE_");
        mappaAB.put("237", "PPE_a");
        mappaAB.put("238", "PPE_b");
        mappaAB.put("239", "PPE_T");
        mappaAB.put("241", "PP_T");
        return mappaAB;
    }

    /*
     * Exception decompiling
     */
    private Balance settaCampi(FullClient full, Balance innerBalance) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[225] lbl1831 : CaseStatement: default:\u000a, @NONE, blocks:[225] lbl1831 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:234)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

