/*
 * Decompiled with CFR 0.152.
 */
package com.vela.balance.data;

import com.vela.balance.data.BalanceRow;
import com.vela.balance.data.BalanceSheet;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class Balance {
    private int lapse1 = 0;
    private int lapse2 = 0;
    private String description = "";
    private BigDecimal dividend = BigDecimal.ZERO;
    private boolean[] sectors = new boolean[10];
    private List<BalanceSheet> sheets = new ArrayList<BalanceSheet>();
    private final transient PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public Balance() {
        Calendar c = Calendar.getInstance();
        this.lapse1 = c.get(1) - 2;
        this.lapse2 = this.lapse1 + 1;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        Optional<String> ol = Optional.ofNullable(this.description);
        Optional<String> nw = Optional.ofNullable(description);
        this.description = description;
        if (ol.orElse("").compareTo(nw.orElse("")) != 0) {
            this.pcs.firePropertyChange("description", ol.orElse(null), this.description);
        }
    }

    public List<BalanceSheet> getSheets() {
        return this.sheets;
    }

    public void setSheets(List<BalanceSheet> sheets) {
        this.sheets = sheets;
    }

    public void addSheet(BalanceSheet sheet) {
        this.sheets.add(sheet);
    }

    public int getLapse1() {
        return this.lapse1;
    }

    public void setLapse1(int lapse1) {
        int ol = this.lapse1;
        this.lapse1 = lapse1;
        if (ol != this.lapse1) {
            this.pcs.firePropertyChange("lapse1", ol, this.lapse1);
        }
    }

    public int getLapse2() {
        return this.lapse2;
    }

    public void setLapse2(int lapse2) {
        int ol = this.lapse2;
        this.lapse2 = lapse2;
        if (ol != this.lapse2) {
            this.pcs.firePropertyChange("lapse2", ol, this.lapse2);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.getDividend() == null ? 0 : this.getDividend().hashCode());
        result = 31 * result + this.lapse1;
        result = 31 * result + this.lapse2;
        result = 31 * result + Arrays.hashCode(this.getSectors());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Balance other = (Balance)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.getDividend() == null ? other.getDividend() != null : !this.getDividend().equals(other.getDividend())) {
            return false;
        }
        if (this.lapse1 != other.lapse1) {
            return false;
        }
        if (this.lapse2 != other.lapse2) {
            return false;
        }
        return Arrays.equals(this.getSectors(), other.getSectors());
    }

    public void loadData(Balance source) {
        this.setDescription(source.getDescription());
        this.setDividend(source.getDividend());
        this.setSectors(source.getSectors());
        this.setLapse1(source.getLapse1());
        this.setLapse2(source.getLapse2());
        int i = 0;
        while (i < this.getSheets().size() && i < source.getSheets().size()) {
            if (this.getSheets().get(i).equals(source.getSheets().get(i))) {
                this.loadSheetData(this.getSheets().get(i), source.getSheets().get(i));
            }
            ++i;
        }
    }

    private void loadSheetData(BalanceSheet target, BalanceSheet source) {
        HashMap rows = new HashMap();
        source.getRows().stream().filter(r -> r.isData()).forEach(r -> {
            BalanceRow balanceRow = rows.put(r.getCode(), r);
        });
        target.getRows().stream().filter(r -> r.isData()).forEach(r -> {
            Optional<BalanceRow> sr = Optional.ofNullable((BalanceRow)rows.get(r.getCode()));
            r.setCurBalance(sr.orElse((BalanceRow)r).getCurBalance());
            r.setPrvBalance(sr.orElse((BalanceRow)r).getPrvBalance());
        });
    }

    public void shiftData() {
        this.setLapse1(this.getLapse2());
        this.setLapse2(this.getLapse1() + 1);
        BigDecimal zero = new BigDecimal("0");
        this.getSheets().stream().flatMap(s -> s.getRows().stream()).filter(r -> r.isData()).forEach(r -> {
            BigDecimal tmp = r.getCurBalance();
            r.setPrvBalance(tmp);
            r.setCurBalance(zero);
        });
    }

    public BigDecimal getDividend() {
        return this.dividend;
    }

    public void setDividend(BigDecimal dividend) {
        Optional<BigDecimal> ol = Optional.ofNullable(this.dividend);
        Optional<BigDecimal> nw = Optional.ofNullable(dividend);
        this.dividend = dividend;
        if (ol.orElse(BigDecimal.ZERO).compareTo(nw.orElse(BigDecimal.ZERO)) != 0) {
            this.pcs.firePropertyChange("dividend", ol.orElse(null), this.dividend);
        }
    }

    public boolean[] getSectors() {
        return this.sectors;
    }

    public void setSectors(boolean[] sectors) {
        boolean[] ol = this.sectors;
        boolean[] nw = sectors;
        this.sectors = sectors;
        if (!Arrays.equals(ol, nw)) {
            this.pcs.firePropertyChange("sectors", ol, this.sectors);
        }
    }
}

