/*
 * Decompiled with CFR 0.152.
 */
package com.vela.balance.data;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.util.Optional;

public class BalanceRow {
    private String code = null;
    private String description = null;
    private String formula = null;
    private BigDecimal curBalance = null;
    private BigDecimal prvBalance = null;
    private boolean total = false;
    private boolean title = false;
    private final transient PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BigDecimal getCurBalance() {
        return this.curBalance;
    }

    public void setCurBalance(BigDecimal curBalance) {
        Optional<BigDecimal> ol = Optional.ofNullable(this.curBalance);
        Optional<BigDecimal> nw = Optional.ofNullable(curBalance);
        this.curBalance = curBalance;
        if (ol.orElse(new BigDecimal("0")).compareTo(nw.orElse(new BigDecimal("0"))) != 0) {
            this.pcs.firePropertyChange("curBalance", ol.orElse(null), this.curBalance);
        }
    }

    public BigDecimal getPrvBalance() {
        return this.prvBalance;
    }

    public void setPrvBalance(BigDecimal prvBalance) {
        Optional<BigDecimal> ol = Optional.ofNullable(this.prvBalance);
        Optional<BigDecimal> nw = Optional.ofNullable(prvBalance);
        this.prvBalance = prvBalance;
        if (ol.orElse(new BigDecimal("0")).compareTo(nw.orElse(new BigDecimal("0"))) != 0) {
            this.pcs.firePropertyChange("prvBalance", ol.orElse(null), this.prvBalance);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BalanceRow other = (BalanceRow)obj;
        return !(this.code == null ? other.code != null : !this.code.equals(other.code));
    }

    public boolean isTitle() {
        return this.title;
    }

    public void setTitle(boolean title) {
        this.title = title;
    }

    public boolean isTotal() {
        return this.total;
    }

    public void setTotal(boolean total) {
        this.total = total;
    }

    public boolean isData() {
        return !this.isTitle() && !this.isTotal();
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        if (formula == null || formula.trim().isEmpty()) {
            return;
        }
        this.formula = formula;
    }
}

