/*
 * Decompiled with CFR 0.152.
 */
package com.vela.common.utils;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;

public class DateHelper {
    private static int MAGIC_NBR = 0;
    private static final Map<Integer, Calendar> easters = new HashMap<Integer, Calendar>();

    public static int toSystemDate(Calendar date) {
        DateHelper.chkMagicNbr();
        if (date == null) {
            return 0;
        }
        int y = date.get(1);
        int m = date.get(2) + 1;
        int d = date.get(5);
        return (y - MAGIC_NBR) * 10000 + m * 100 + d;
    }

    public static LocalDate fromSystemDateToLD(int date) {
        return DateHelper.fromSystemDate(date).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Calendar fromSystemDate(int date) {
        DateHelper.chkMagicNbr();
        Calendar c = Calendar.getInstance();
        if (date == 0) {
            c.setTime(new Date(0L));
        }
        if (date == 999999) {
            c.setTime(new Date(Long.MAX_VALUE));
        }
        int y = date / 10000;
        int m = (date - y * 10000) / 100;
        int d = date - y * 10000 - m * 100;
        c.set(y + MAGIC_NBR, m - 1, d, 0, 0, 0);
        c.set(14, 0);
        return c;
    }

    public static int fromSystemYear(int year) {
        if (year == 0) {
            return 0;
        }
        DateHelper.chkMagicNbr();
        return year + MAGIC_NBR;
    }

    private static void chkMagicNbr() {
        if (MAGIC_NBR == 0) {
            throw new RuntimeException("Il gestore delle date a sistema non \u00e8 stato correttamente inizializzato");
        }
    }

    public static Integer toSystemYear(Integer year) {
        if (year == 0) {
            return 0;
        }
        DateHelper.chkMagicNbr();
        return year - MAGIC_NBR;
    }

    public static Calendar addDays(Calendar source, int days, int months, boolean onlywrk) {
        Calendar dest = (Calendar)source.clone();
        while (days > 0) {
            dest.add(5, 1);
            if (onlywrk && DateHelper.isHolyday(dest)) continue;
            --days;
        }
        if (months != 0) {
            dest.add(2, months);
        }
        return dest;
    }

    private static boolean isHolyday(Calendar c) {
        if (c.get(7) == 1) {
            return true;
        }
        if (c.get(2) == 0 && c.get(5) == 1) {
            return true;
        }
        if (c.get(2) == 0 && c.get(5) == 6) {
            return true;
        }
        if (c.get(2) == 3 && c.get(5) == 25) {
            return true;
        }
        if (c.get(2) == 4 && c.get(5) == 1) {
            return true;
        }
        if (c.get(2) == 5 && c.get(5) == 2) {
            return true;
        }
        if (c.get(2) == 7 && c.get(5) == 15) {
            return true;
        }
        if (c.get(2) == 10 && c.get(5) == 1) {
            return true;
        }
        if (c.get(2) == 11 && c.get(5) == 8) {
            return true;
        }
        if (c.get(2) == 11 && c.get(5) == 25) {
            return true;
        }
        if (c.get(2) == 11 && c.get(5) == 26) {
            return true;
        }
        Calendar easter = easters.computeIfAbsent(c.get(1), DateHelper::findEaster);
        if (DateUtils.truncatedEquals((Calendar)c, (Calendar)easter, (int)5)) {
            return true;
        }
        Calendar e1 = (Calendar)easter.clone();
        e1.add(5, 1);
        return DateUtils.truncatedEquals((Calendar)c, (Calendar)e1, (int)5);
    }

    private static Calendar findEaster(int year) {
        if (year < 1573 || year > 2499) {
            throw new RuntimeException("Impossibile calcolare il gg di pasqua");
        }
        int a = year % 19;
        int b = year % 4;
        int c = year % 7;
        int m = 0;
        int n = 0;
        if (year >= 1583 && year <= 1699) {
            m = 22;
            n = 2;
        }
        if (year >= 1700 && year <= 1799) {
            m = 23;
            n = 3;
        }
        if (year >= 1800 && year <= 1899) {
            m = 23;
            n = 4;
        }
        if (year >= 1900 && year <= 2099) {
            m = 24;
            n = 5;
        }
        if (year >= 2100 && year <= 2199) {
            m = 24;
            n = 6;
        }
        if (year >= 2200 && year <= 2299) {
            m = 25;
            n = 0;
        }
        if (year >= 2300 && year <= 2399) {
            m = 26;
            n = 1;
        }
        if (year >= 2400 && year <= 2499) {
            m = 25;
            n = 1;
        }
        int d = (19 * a + m) % 30;
        int e = (2 * b + 4 * c + 6 * d + n) % 7;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, year);
        if (d + e < 10) {
            calendar.set(2, 2);
            calendar.set(5, d + e + 22);
        } else {
            calendar.set(2, 3);
            int day = d + e - 9;
            if (26 == day) {
                day = 19;
            }
            if (25 == day && 28 == d && e == 6 && a > 10) {
                day = 18;
            }
            calendar.set(5, day);
        }
        return calendar;
    }

    public static void init(boolean xconda) {
        MAGIC_NBR = xconda ? 1940 : 2000;
    }

    public static int toSystemDate(LocalDate date) {
        return DateHelper.toSystemDate(GregorianCalendar.from(date.atStartOfDay(ZoneId.systemDefault())));
    }
}

